/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.springframework.graphql.data.federation.EntityArgumentMethodArgumentResolver;
import org.springframework.graphql.data.federation.FederationSchemaFactory;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.DataFetcherHandlerMethodSupport;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

final class EntityHandlerMethod
extends DataFetcherHandlerMethodSupport {
    private final boolean batchHandlerMethod;

    EntityHandlerMethod(FederationSchemaFactory.EntityMappingInfo info, HandlerMethodArgumentResolverComposite resolvers, @Nullable Executor executor, boolean invokeAsync) {
        super(info.handlerMethod(), resolvers, executor, invokeAsync);
        this.batchHandlerMethod = info.isBatchHandlerMethod();
    }

    boolean isBatchHandlerMethod() {
        return this.batchHandlerMethod;
    }

    Mono<Object> getEntity(DataFetchingEnvironment env, Map<String, Object> representation) {
        Object[] args;
        try {
            env = EntityArgumentMethodArgumentResolver.wrap(env, representation);
            args = this.getMethodArgumentValues(env, new Object[0]);
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
        return this.doInvoke(env, args);
    }

    Mono<Object> getEntities(DataFetchingEnvironment env, List<Map<String, Object>> representations) {
        Object[] args;
        try {
            env = EntityArgumentMethodArgumentResolver.wrap(env, representations);
            args = this.getMethodArgumentValues(env, new Object[0]);
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
        return this.doInvoke(env, args);
    }

    private Mono<Object> doInvoke(DataFetchingEnvironment env, Object[] args) {
        Object result = this.doInvoke(env.getGraphQlContext(), args);
        if (result instanceof Mono) {
            Mono mono = (Mono)result;
            return mono.cast(Object.class);
        }
        if (result instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)result;
            return Mono.fromFuture((CompletableFuture)future);
        }
        return Mono.justOrEmpty((Object)result);
    }
}

