/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class GraphQlRequestPredicates {
    private static final Log logger = LogFactory.getLog(GraphQlRequestPredicates.class);

    private GraphQlRequestPredicates() {
    }

    public static RequestPredicate graphQlHttp(String path) {
        return new GraphQlHttpRequestPredicate(path, List.of(MediaType.APPLICATION_JSON, MediaType.APPLICATION_GRAPHQL_RESPONSE));
    }

    public static RequestPredicate graphQlSse(String path) {
        return new GraphQlHttpRequestPredicate(path, List.of(MediaType.TEXT_EVENT_STREAM));
    }

    private static class GraphQlHttpRequestPredicate
    implements RequestPredicate {
        private final PathPattern pattern;
        private final List<MediaType> contentTypes;
        private final List<MediaType> acceptedMediaTypes;

        GraphQlHttpRequestPredicate(String path, List<MediaType> accepted) {
            Assert.notNull((Object)path, (String)"'path' must not be null");
            Assert.notEmpty(accepted, (String)"'accepted' must not be empty");
            PathPatternParser parser = PathPatternParser.defaultInstance;
            path = parser.initFullPathPattern(path);
            this.pattern = parser.parse(path);
            this.contentTypes = List.of(MediaType.APPLICATION_JSON, MediaType.parseMediaType((String)"application/graphql"));
            this.acceptedMediaTypes = accepted;
        }

        public boolean test(ServerRequest request) {
            return GraphQlHttpRequestPredicate.httpMethodMatch(request, HttpMethod.POST) && GraphQlHttpRequestPredicate.contentTypeMatch(request, this.contentTypes) && GraphQlHttpRequestPredicate.acceptMatch(request, this.acceptedMediaTypes) && GraphQlHttpRequestPredicate.pathMatch(request, this.pattern);
        }

        private static boolean httpMethodMatch(ServerRequest request, HttpMethod expected) {
            HttpMethod actual = GraphQlHttpRequestPredicate.resolveHttpMethod(request);
            boolean methodMatch = expected.equals((Object)actual);
            GraphQlHttpRequestPredicate.traceMatch("Method", expected, actual, methodMatch);
            return methodMatch;
        }

        private static HttpMethod resolveHttpMethod(ServerRequest request) {
            String httpMethod;
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request.servletRequest()) && (httpMethod = request.headers().firstHeader("Access-Control-Request-Method")) != null) {
                return HttpMethod.valueOf((String)httpMethod);
            }
            return request.method();
        }

        private static boolean contentTypeMatch(ServerRequest request, List<MediaType> contentTypes) {
            MediaType actual;
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request.servletRequest())) {
                return true;
            }
            ServerRequest.Headers headers = request.headers();
            try {
                actual = headers.contentType().orElse(MediaType.APPLICATION_OCTET_STREAM);
            }
            catch (InvalidMediaTypeException ex) {
                throw new UnsupportedMediaTypeStatusException("Could not parse Content-Type [" + headers.firstHeader("Content-Type") + "]: " + ex.getMessage());
            }
            boolean contentTypeMatch = false;
            for (MediaType contentType : contentTypes) {
                contentTypeMatch = contentType.includes(actual);
                GraphQlHttpRequestPredicate.traceMatch("Content-Type", contentTypes, actual, contentTypeMatch);
                if (!contentTypeMatch) continue;
                break;
            }
            return contentTypeMatch;
        }

        private static boolean acceptMatch(ServerRequest request, List<MediaType> expected) {
            List<MediaType> acceptedMediaTypes;
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request.servletRequest())) {
                return true;
            }
            ServerRequest.Headers headers = request.headers();
            try {
                acceptedMediaTypes = GraphQlHttpRequestPredicate.acceptedMediaTypes(headers);
            }
            catch (InvalidMediaTypeException ex) {
                throw new NotAcceptableStatusException("Could not parse Accept header [" + headers.firstHeader("Accept") + "]: " + ex.getMessage());
            }
            boolean match = false;
            block2: for (MediaType acceptedMediaType : acceptedMediaTypes) {
                for (MediaType mediaType : expected) {
                    if (!acceptedMediaType.isCompatibleWith(mediaType)) continue;
                    match = true;
                    break block2;
                }
            }
            GraphQlHttpRequestPredicate.traceMatch("Accept", expected, acceptedMediaTypes, match);
            return match;
        }

        private static List<MediaType> acceptedMediaTypes(ServerRequest.Headers headers) {
            List<MediaType> acceptedMediaTypes = headers.accept();
            if (acceptedMediaTypes.isEmpty()) {
                acceptedMediaTypes = Collections.singletonList(MediaType.ALL);
            } else {
                MimeTypeUtils.sortBySpecificity((List)acceptedMediaTypes);
            }
            return acceptedMediaTypes;
        }

        private static boolean pathMatch(ServerRequest request, PathPattern pattern) {
            PathContainer pathContainer = request.requestPath().pathWithinApplication();
            boolean pathMatch = pattern.matches(pathContainer);
            GraphQlHttpRequestPredicate.traceMatch("Pattern", pattern.getPatternString(), request.path(), pathMatch);
            if (pathMatch) {
                request.attributes().put(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE, pattern);
            }
            return pathMatch;
        }

        private static void traceMatch(String prefix, Object desired, @Nullable Object actual, boolean match) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual));
            }
        }
    }
}

