/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import com.netflix.graphql.dgs.client.codegen.BaseProjectionNode;
import com.netflix.graphql.dgs.client.codegen.GraphQLMultiQueryRequest;
import com.netflix.graphql.dgs.client.codegen.GraphQLQuery;
import com.netflix.graphql.dgs.client.codegen.GraphQLQueryRequest;
import graphql.schema.Coercing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.client.ClientGraphQlResponse;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DgsGraphQlClient {
    private final GraphQlClient graphQlClient;

    private DgsGraphQlClient(GraphQlClient graphQlClient) {
        this.graphQlClient = graphQlClient;
    }

    public GraphQlClient getGraphQlClient() {
        return this.graphQlClient;
    }

    public RequestSpec request(GraphQLQuery query) {
        return new RequestSpec(query);
    }

    public static DgsGraphQlClient create(GraphQlClient client) {
        return new DgsGraphQlClient(client);
    }

    public final class RequestSpec {
        private final GraphQLQuery query;
        private final List<GraphQLQueryRequest> additionalRequests;
        private @Nullable BaseProjectionNode projectionNode;
        private @Nullable Map<Class<?>, Coercing<?, ?>> coercingMap;
        private @Nullable Map<String, Object> attributes;

        private RequestSpec(GraphQLQuery query) {
            this(query, Collections.emptyList(), null);
        }

        private RequestSpec(GraphQLQuery query, @Nullable List<GraphQLQueryRequest> additionalRequests, Map<String, Object> existingAttributes) {
            Assert.notNull((Object)query, (String)"Expected GraphQLQuery");
            Assert.notNull(additionalRequests, (String)"Expected additionalRequests");
            this.query = query;
            this.additionalRequests = additionalRequests;
            if (existingAttributes != null) {
                this.attributes(attr -> attr.putAll(existingAttributes));
            }
        }

        public RequestSpec queryAlias(String queryAlias) {
            this.query.setQueryAlias(queryAlias);
            return this;
        }

        public RequestSpec projection(BaseProjectionNode projectionNode) {
            this.projectionNode = projectionNode;
            return this;
        }

        public RequestSpec coercing(Class<?> scalarType, Coercing<?, ?> coercing) {
            this.coercingMap = this.coercingMap != null ? this.coercingMap : new LinkedHashMap();
            this.coercingMap.put(scalarType, coercing);
            return this;
        }

        public RequestSpec coercing(Map<Class<?>, Coercing<?, ?>> coercingMap) {
            this.coercingMap = this.coercingMap != null ? this.coercingMap : new LinkedHashMap();
            this.coercingMap.putAll(coercingMap);
            return this;
        }

        public RequestSpec attribute(String name, Object value) {
            this.attributes = this.attributes != null ? this.attributes : new HashMap<String, Object>();
            this.attributes.put(name, value);
            return this;
        }

        public RequestSpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            this.attributes = this.attributes != null ? this.attributes : new HashMap<String, Object>();
            attributesConsumer.accept(this.attributes);
            return this;
        }

        public RequestSpec request(GraphQLQuery query) {
            ArrayList<GraphQLQueryRequest> otherRequests = new ArrayList<GraphQLQueryRequest>(this.additionalRequests);
            otherRequests.add(this.createRequest());
            return new RequestSpec(query, otherRequests, this.attributes);
        }

        public GraphQlClient.RetrieveSyncSpec retrieveSync() {
            return this.initRequestSpec().retrieveSync(this.getDefaultPath());
        }

        public GraphQlClient.RetrieveSyncSpec retrieveSync(String path) {
            return this.initRequestSpec().retrieveSync(path);
        }

        public GraphQlClient.RetrieveSpec retrieve() {
            return this.initRequestSpec().retrieve(this.getDefaultPath());
        }

        public GraphQlClient.RetrieveSpec retrieve(String path) {
            return this.initRequestSpec().retrieve(path);
        }

        public GraphQlClient.RetrieveSubscriptionSpec retrieveSubscription() {
            return this.initRequestSpec().retrieveSubscription(this.getDefaultPath());
        }

        public ClientGraphQlResponse executeSync() {
            return this.initRequestSpec().executeSync();
        }

        public Mono<ClientGraphQlResponse> execute() {
            return this.initRequestSpec().execute();
        }

        public Flux<ClientGraphQlResponse> executeSubscription() {
            return this.initRequestSpec().executeSubscription();
        }

        private GraphQLQueryRequest createRequest() {
            Assert.state((this.projectionNode != null || this.coercingMap == null ? 1 : 0) != 0, (String)"Coercing map provided without projection");
            GraphQLQueryRequest request = this.coercingMap != null && this.projectionNode != null ? new GraphQLQueryRequest(this.query, this.projectionNode, this.coercingMap) : (this.projectionNode != null ? new GraphQLQueryRequest(this.query, this.projectionNode) : new GraphQLQueryRequest(this.query));
            return request;
        }

        private GraphQlClient.RequestSpec initRequestSpec() {
            String operationName;
            String document;
            if (!this.additionalRequests.isEmpty()) {
                this.additionalRequests.add(this.createRequest());
                document = new GraphQLMultiQueryRequest(this.additionalRequests).serialize();
                operationName = null;
            } else {
                document = this.createRequest().serialize();
                operationName = this.query.getName() != null ? this.query.getName() : null;
            }
            return DgsGraphQlClient.this.graphQlClient.document(document).operationName(operationName).attributes(map -> {
                if (this.attributes != null) {
                    map.putAll(this.attributes);
                }
            });
        }

        private String getDefaultPath() {
            return this.query.getOperationName();
        }
    }
}

