/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.instrumentation.dataloader.EmptyDataLoaderRegistryInstance;
import io.micrometer.context.ContextSnapshotFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.dataloader.DataLoaderRegistry;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.ContextPropagationHelper;
import org.springframework.graphql.execution.DataLoaderRegistrar;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.support.DefaultExecutionGraphQlResponse;
import reactor.core.publisher.Mono;

public class DefaultExecutionGraphQlService
implements ExecutionGraphQlService {
    private static final BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput> RESET_EXECUTION_ID_CONFIGURER = (executionInput, builder) -> builder.executionId(null).build();
    private final GraphQlSource graphQlSource;
    private final List<DataLoaderRegistrar> dataLoaderRegistrars = new ArrayList<DataLoaderRegistrar>();
    private @Nullable Boolean hasDataLoaderRegistrations;
    private final boolean isDefaultExecutionIdProvider;

    public DefaultExecutionGraphQlService(GraphQlSource graphQlSource) {
        this.graphQlSource = graphQlSource;
        this.isDefaultExecutionIdProvider = graphQlSource.graphQl().getIdProvider() == ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
    }

    public void addDataLoaderRegistrar(DataLoaderRegistrar registrar) {
        this.dataLoaderRegistrars.add(registrar);
    }

    @Override
    public final Mono<ExecutionGraphQlResponse> execute(ExecutionGraphQlRequest request) {
        return Mono.deferContextual(contextView -> {
            if (!this.isDefaultExecutionIdProvider && request.getExecutionId() == null) {
                request.configureExecutionInput(RESET_EXECUTION_ID_CONFIGURER);
            }
            ExecutionInput executionInput = request.toExecutionInput();
            ContextSnapshotFactory factory = ContextPropagationHelper.getInstance(contextView);
            GraphQLContext graphQLContext = executionInput.getGraphQLContext();
            ContextPropagationHelper.saveInstance(factory, graphQLContext);
            factory.captureFrom(new Object[]{contextView}).updateContext((Object)graphQLContext);
            ExecutionInput executionInputToUse = this.registerDataLoaders(executionInput);
            Runnable cancelSignal = ContextPropagationHelper.createCancelSignal(graphQLContext);
            return Mono.fromFuture((CompletableFuture)this.graphQlSource.graphQl().executeAsync(executionInputToUse)).onErrorResume(ex -> ex instanceof GraphQLError, ex -> Mono.just((Object)ExecutionResult.newExecutionResult().addError((GraphQLError)ex).build())).map(result -> new DefaultExecutionGraphQlResponse(executionInputToUse, (ExecutionResult)result)).doOnCancel(cancelSignal::run);
        });
    }

    private ExecutionInput registerDataLoaders(ExecutionInput executionInput) {
        if (this.hasDataLoaderRegistrations == null) {
            this.hasDataLoaderRegistrations = this.initHasDataLoaderRegistrations();
        }
        if (this.hasDataLoaderRegistrations.booleanValue()) {
            GraphQLContext graphQLContext = executionInput.getGraphQLContext();
            DataLoaderRegistry existingRegistry = executionInput.getDataLoaderRegistry();
            if (existingRegistry == EmptyDataLoaderRegistryInstance.EMPTY_DATALOADER_REGISTRY) {
                DataLoaderRegistry newRegistry = DataLoaderRegistry.newRegistry().build();
                this.applyDataLoaderRegistrars(newRegistry, graphQLContext);
                executionInput = executionInput.transform(builder -> builder.dataLoaderRegistry(newRegistry));
            } else {
                this.applyDataLoaderRegistrars(existingRegistry, graphQLContext);
            }
        }
        return executionInput;
    }

    private boolean initHasDataLoaderRegistrations() {
        for (DataLoaderRegistrar registrar : this.dataLoaderRegistrars) {
            if (!registrar.hasRegistrations()) continue;
            return true;
        }
        return false;
    }

    private void applyDataLoaderRegistrars(DataLoaderRegistry registry, GraphQLContext graphQLContext) {
        this.dataLoaderRegistrars.forEach(registrar -> registrar.registerDataLoaders(registry, graphQLContext));
    }
}

