/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.support;

import graphql.ErrorClassification;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.support.AbstractGraphQlResponse;
import org.springframework.util.Assert;

public class DefaultExecutionGraphQlResponse
extends AbstractGraphQlResponse
implements ExecutionGraphQlResponse {
    private final ExecutionInput input;
    private final ExecutionResult result;

    public DefaultExecutionGraphQlResponse(ExecutionInput input, ExecutionResult result) {
        Assert.notNull((Object)input, (String)"ExecutionInput is required");
        Assert.notNull((Object)result, (String)"ExecutionResult is required");
        this.input = input;
        this.result = result;
    }

    protected DefaultExecutionGraphQlResponse(ExecutionGraphQlResponse response) {
        this(response.getExecutionInput(), response.getExecutionResult());
    }

    @Override
    public ExecutionInput getExecutionInput() {
        return this.input;
    }

    @Override
    public ExecutionResult getExecutionResult() {
        return this.result;
    }

    @Override
    public boolean isValid() {
        return this.result.isDataPresent() && this.result.getData() != null;
    }

    @Override
    public <T> @Nullable T getData() {
        return (T)this.result.getData();
    }

    @Override
    public List<ResponseError> getErrors() {
        return this.result.getErrors().stream().map(GraphQLErrorResponseError::new).collect(Collectors.toList());
    }

    @Override
    public Map<Object, Object> getExtensions() {
        return this.result.getExtensions() != null ? this.result.getExtensions() : Collections.emptyMap();
    }

    @Override
    public Map<String, Object> toMap() {
        return this.result.toSpecification();
    }

    public String toString() {
        return this.result.toString();
    }

    public static abstract class Builder<B extends Builder<B, R>, R extends ExecutionGraphQlResponse> {
        private final R original;
        private final ExecutionResultImpl.Builder<?> executionResultBuilder;

        protected Builder(R original) {
            this.original = original;
            this.executionResultBuilder = ExecutionResultImpl.newExecutionResult().from(original.getExecutionResult());
        }

        public Builder<B, R> data(Object data) {
            this.executionResultBuilder.data(data);
            return this;
        }

        public Builder<B, R> errors(@Nullable List<GraphQLError> errors) {
            this.executionResultBuilder.errors(errors);
            return this;
        }

        public Builder<B, R> extensions(@Nullable Map<Object, Object> extensions) {
            this.executionResultBuilder.extensions(extensions);
            return this;
        }

        public R build() {
            return this.build(this.original, this.executionResultBuilder.build());
        }

        protected abstract R build(R var1, ExecutionResult var2);
    }

    private record GraphQLErrorResponseError(GraphQLError delegate) implements ResponseError
    {
        @Override
        public String getMessage() {
            return this.delegate.getMessage();
        }

        @Override
        public List<SourceLocation> getLocations() {
            return this.delegate.getLocations();
        }

        @Override
        public ErrorClassification getErrorType() {
            return this.delegate.getErrorType();
        }

        @Override
        public String getPath() {
            return this.getParsedPath().stream().reduce("", (s, o) -> s + String.valueOf(o instanceof Integer ? "[" + String.valueOf(o) + "]" : (s.isEmpty() ? o : "." + String.valueOf(o))), (s, s2) -> null);
        }

        @Override
        public List<Object> getParsedPath() {
            return this.delegate.getPath() != null ? this.delegate.getPath() : Collections.emptyList();
        }

        @Override
        public Map<String, Object> getExtensions() {
            return this.delegate.getExtensions() != null ? this.delegate.getExtensions() : Collections.emptyMap();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }
}

