/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.ReferenceTypeSerializer;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.reflect.Type;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.data.ArgumentValue;

public class GraphQlJackson2Module
extends Module {
    public String getModuleName() {
        return GraphQlJackson2Module.class.getName();
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new GraphQlSerializers());
        context.addTypeModifier((TypeModifier)new ArgumentValueTypeModifier());
        context.configOverride(ArgumentValue.class).setInclude(JsonInclude.Value.empty().withValueInclusion(JsonInclude.Include.NON_ABSENT));
    }

    static class GraphQlSerializers
    extends Serializers.Base {
        GraphQlSerializers() {
        }

        public @Nullable JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType refType, BeanDescription beanDesc, @Nullable TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
            Class raw = refType.getRawClass();
            if (ArgumentValue.class.isAssignableFrom(raw)) {
                boolean staticTyping = contentTypeSerializer == null && config.isEnabled(MapperFeature.USE_STATIC_TYPING);
                return new ArgumentValueSerializer(refType, staticTyping, contentTypeSerializer, contentValueSerializer);
            }
            return null;
        }
    }

    static class ArgumentValueTypeModifier
    extends TypeModifier {
        ArgumentValueTypeModifier() {
        }

        public JavaType modifyType(JavaType type, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
            Class raw = type.getRawClass();
            if (!type.isReferenceType() && !type.isContainerType() && raw == ArgumentValue.class) {
                JavaType refType = type.containedTypeOrUnknown(0);
                return ReferenceType.upgradeFrom((JavaType)type, (JavaType)refType);
            }
            return type;
        }
    }

    static class ArgumentValueSerializer
    extends ReferenceTypeSerializer<ArgumentValue<?>> {
        private static final long serialVersionUID = 1L;

        ArgumentValueSerializer(ReferenceType fullType, boolean staticTyping, @Nullable TypeSerializer vts, JsonSerializer<Object> ser) {
            super(fullType, staticTyping, vts, ser);
        }

        ArgumentValueSerializer(ArgumentValueSerializer base, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper, Object suppressableValue, boolean suppressNulls) {
            super((ReferenceTypeSerializer)base, property, vts, valueSer, unwrapper, suppressableValue, suppressNulls);
        }

        protected ReferenceTypeSerializer<ArgumentValue<?>> withResolved(BeanProperty prop, TypeSerializer vts, JsonSerializer<?> valueSer, NameTransformer unwrapper) {
            return new ArgumentValueSerializer(this, prop, vts, valueSer, unwrapper, this._suppressableValue, this._suppressNulls);
        }

        public ReferenceTypeSerializer<ArgumentValue<?>> withContentInclusion(Object suppressableValue, boolean suppressNulls) {
            return new ArgumentValueSerializer(this, this._property, this._valueTypeSerializer, this._valueSerializer, this._unwrapper, suppressableValue, suppressNulls);
        }

        protected boolean _isValuePresent(ArgumentValue<?> value) {
            return !value.isOmitted();
        }

        protected @Nullable Object _getReferenced(ArgumentValue<?> value) {
            return value.value();
        }

        protected @Nullable Object _getReferencedIfPresent(ArgumentValue<?> value) {
            return value.value();
        }
    }
}

