/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webmvc;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.MediaTypes;
import org.springframework.graphql.server.WebGraphQlHandler;
import org.springframework.graphql.server.WebGraphQlResponse;
import org.springframework.graphql.server.webmvc.AbstractGraphQlHttpHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.server.NotAcceptableStatusException;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;
import reactor.core.publisher.Mono;

public class GraphQlHttpHandler
extends AbstractGraphQlHttpHandler {
    private static final MediaType APPLICATION_GRAPHQL = new MediaType("application", "graphql+json");
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = List.of(MediaTypes.APPLICATION_GRAPHQL_RESPONSE, MediaType.APPLICATION_JSON, APPLICATION_GRAPHQL);
    private boolean httpOkOnValidationErrors = false;

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler) {
        super(graphQlHandler, null);
    }

    public GraphQlHttpHandler(WebGraphQlHandler graphQlHandler, @Nullable HttpMessageConverter<?> converter) {
        super(graphQlHandler, converter);
    }

    public boolean isHttpOkOnValidationErrors() {
        return this.httpOkOnValidationErrors;
    }

    @Deprecated(since="1.4.0", forRemoval=true)
    public void setHttpOkOnValidationErrors(boolean httpOkOnValidationErrors) {
        this.httpOkOnValidationErrors = httpOkOnValidationErrors;
    }

    @Override
    protected ServerResponse prepareResponse(ServerRequest request, Mono<WebGraphQlResponse> responseMono) {
        Mono mono = responseMono.map(response -> {
            MediaType contentType = GraphQlHttpHandler.selectResponseMediaType(request);
            HttpStatus responseStatus = this.selectResponseStatus((WebGraphQlResponse)response, contentType);
            ServerResponse.BodyBuilder builder = ServerResponse.status((HttpStatusCode)responseStatus);
            builder.headers(headers -> headers.putAll(response.getResponseHeaders()));
            builder.contentType(contentType);
            Map<String, Object> resultMap = response.toMap();
            ServerResponse.HeadersBuilder.WriteFunction writer = this.getWriteFunction(resultMap, contentType);
            return writer != null ? builder.build(writer) : builder.body(resultMap);
        });
        return ServerResponse.async((Object)mono.toFuture());
    }

    protected HttpStatus selectResponseStatus(WebGraphQlResponse response, MediaType responseMediaType) {
        if (!this.isHttpOkOnValidationErrors() && !response.getExecutionResult().isDataPresent() && MediaTypes.APPLICATION_GRAPHQL_RESPONSE.equals((Object)responseMediaType)) {
            return HttpStatus.BAD_REQUEST;
        }
        return HttpStatus.OK;
    }

    private static MediaType selectResponseMediaType(ServerRequest request) {
        List acceptedMediaTypes;
        ServerRequest.Headers headers = request.headers();
        try {
            acceptedMediaTypes = headers.accept();
        }
        catch (InvalidMediaTypeException ex) {
            throw new NotAcceptableStatusException("Could not parse Accept header [" + headers.firstHeader("Accept") + "]: " + ex.getMessage());
        }
        for (MediaType mediaType : acceptedMediaTypes) {
            if (!SUPPORTED_MEDIA_TYPES.contains(mediaType)) continue;
            return mediaType;
        }
        return MediaType.APPLICATION_JSON;
    }
}

