/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.grpc.client.GrpcChannelBuilderCustomizer;

public class ChannelBuilderCustomizers {
    private final List<GrpcChannelBuilderCustomizer<?>> customizers;

    ChannelBuilderCustomizers(List<? extends GrpcChannelBuilderCustomizer<?>> customizers) {
        this.customizers = customizers != null ? new ArrayList(customizers) : Collections.emptyList();
    }

    <T extends ManagedChannelBuilder<?>> T customize(String authority, T channelBuilder) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(GrpcChannelBuilderCustomizer.class, this.customizers, channelBuilder, (Object[])new Object[0]).withLogger(ChannelBuilderCustomizers.class)).invoke(customizer -> customizer.customize(authority, channelBuilder));
        return channelBuilder;
    }
}

