/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Primary;
import org.springframework.grpc.client.CompositeGrpcChannelFactory;
import org.springframework.grpc.client.GrpcChannelFactory;

@AutoConfiguration
@Conditional(value={MultipleNonPrimaryChannelFactoriesCondition.class})
class CompositeChannelFactoryAutoConfiguration {
    CompositeChannelFactoryAutoConfiguration() {
    }

    @Bean
    @Primary
    CompositeGrpcChannelFactory compositeChannelFactory(ObjectProvider<GrpcChannelFactory> channelFactoriesProvider) {
        return new CompositeGrpcChannelFactory(channelFactoriesProvider.orderedStream().toList());
    }

    static class MultipleNonPrimaryChannelFactoriesCondition
    extends NoneNestedConditions {
        MultipleNonPrimaryChannelFactoriesCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnSingleCandidate(value=GrpcChannelFactory.class)
        static class SingleInjectableChannelFactoryCondition {
            SingleInjectableChannelFactoryCondition() {
            }
        }

        @ConditionalOnMissingBean(value={GrpcChannelFactory.class})
        static class NoChannelFactoryCondition {
            NoChannelFactoryCondition() {
            }
        }
    }
}

