/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.common.codec;

import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Codec.class})
public class GrpcCodecConfiguration {
    @Bean
    CompressorRegistry compressorRegistry(ObjectProvider<Compressor> compressors) {
        CompressorRegistry registry = CompressorRegistry.getDefaultInstance();
        compressors.orderedStream().forEachOrdered(arg_0 -> ((CompressorRegistry)registry).register(arg_0));
        return registry;
    }

    @Bean
    DecompressorRegistry decompressorRegistry(ObjectProvider<Decompressor> decompressors) {
        DecompressorRegistry registry = DecompressorRegistry.getDefaultInstance();
        decompressors.orderedStream().forEachOrdered(decompressor -> registry.with(decompressor, false));
        return registry;
    }
}

