/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server;

import io.grpc.BindableService;
import io.grpc.servlet.jakarta.GrpcServlet;
import io.grpc.servlet.jakarta.ServletServerBuilder;
import jakarta.servlet.Servlet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.grpc.autoconfigure.server.ConditionalOnGrpcServerEnabled;
import org.springframework.grpc.autoconfigure.server.GrpcServerFactoryConfigurations;
import org.springframework.grpc.autoconfigure.server.GrpcServerProperties;
import org.springframework.grpc.autoconfigure.server.ServerBuilderCustomizers;
import org.springframework.grpc.server.service.GrpcServiceConfigurer;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.util.unit.DataSize;

@AutoConfiguration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnGrpcServerEnabled
@ConditionalOnBean(value={BindableService.class})
public class GrpcServerFactoryAutoConfiguration {

    public static class OnNativeGrpcServerCondition
    extends AnyNestedCondition {
        OnNativeGrpcServerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        static class OnExplicitlyDisabledWebflux {
            OnExplicitlyDisabledWebflux() {
            }
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        @ConditionalOnClass(value={GrpcServlet.class})
        @ConditionalOnProperty(prefix="spring.grpc.server", name={"servlet.enabled"}, havingValue="false", matchIfMissing=false)
        static class OnExplicitlyDisabledServlet {
            OnExplicitlyDisabledServlet() {
            }
        }

        @ConditionalOnMissingClass(value={"io.grpc.servlet.jakarta.GrpcServlet"})
        static class OnGrpcServletClass {
            OnGrpcServletClass() {
            }
        }

        @ConditionalOnNotWebApplication
        static class OnNonWebApplication {
            OnNonWebApplication() {
            }
        }
    }

    public static class OnGrpcServletCondition
    extends AllNestedConditions {
        OnGrpcServletCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.grpc.server", name={"servlet.enabled"}, havingValue="true", matchIfMissing=true)
        static class OnExplicitlyEnabled {
            OnExplicitlyEnabled() {
            }
        }

        @ConditionalOnClass(value={GrpcServlet.class})
        static class OnGrpcServletClass {
            OnGrpcServletClass() {
            }
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        static class OnServletWebApplication {
            OnServletWebApplication() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnGrpcServletCondition.class})
    public static class GrpcServletConfiguration {
        private static Log logger = LogFactory.getLog(GrpcServletConfiguration.class);

        @Bean
        public ServletRegistrationBean<GrpcServlet> grpcServlet(GrpcServerProperties properties, GrpcServiceDiscoverer serviceDiscoverer, GrpcServiceConfigurer serviceConfigurer, ServerBuilderCustomizers serverBuilderCustomizers) {
            List serviceNames = serviceDiscoverer.listServiceNames();
            if (logger.isInfoEnabled()) {
                serviceNames.forEach(service -> logger.info((Object)("Registering gRPC service: " + service)));
            }
            List paths = serviceNames.stream().map(service -> "/" + service + "/*").collect(Collectors.toList());
            ServletServerBuilder servletServerBuilder = new ServletServerBuilder();
            serviceDiscoverer.findServices().stream().map(serviceSpec -> serviceConfigurer.configure(serviceSpec, null)).forEach(arg_0 -> ((ServletServerBuilder)servletServerBuilder).addService(arg_0));
            PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
            mapper.from((Object)properties.getMaxInboundMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> ((ServletServerBuilder)servletServerBuilder).maxInboundMessageSize(arg_0));
            serverBuilderCustomizers.customize(servletServerBuilder);
            ServletRegistrationBean servlet = new ServletRegistrationBean((Servlet)servletServerBuilder.buildServlet(), new String[0]);
            servlet.setUrlMappings(paths);
            return servlet;
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={GrpcServerFactoryConfigurations.InProcessServerFactoryConfiguration.class})
        static class InProcessConfiguration {
            InProcessConfiguration() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnNativeGrpcServerCondition.class})
    static class GrpcServerFactoryConfiguration {
        GrpcServerFactoryConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        @Import(value={GrpcServerFactoryConfigurations.ShadedNettyServerFactoryConfiguration.class, GrpcServerFactoryConfigurations.NettyServerFactoryConfiguration.class, GrpcServerFactoryConfigurations.InProcessServerFactoryConfiguration.class})
        static class NettyServerFactoryConfiguration {
            NettyServerFactoryConfiguration() {
            }
        }
    }
}

