/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server;

import io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerInterceptor;
import io.micrometer.core.instrument.kotlin.ObservationCoroutineContextServerInterceptor;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.grpc.autoconfigure.server.ConditionalOnGrpcServerEnabled;
import org.springframework.grpc.server.GlobalServerInterceptor;

@AutoConfiguration(afterName={"org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration"})
@ConditionalOnGrpcServerEnabled
@ConditionalOnClass(value={ObservationRegistry.class, ObservationGrpcServerInterceptor.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@ConditionalOnProperty(name={"spring.grpc.server.observation.enabled"}, havingValue="true", matchIfMissing=true)
public class GrpcServerObservationAutoConfiguration {
    @Bean
    @Order(value=0)
    @GlobalServerInterceptor
    ObservationGrpcServerInterceptor observationGrpcServerInterceptor(ObservationRegistry observationRegistry) {
        return new ObservationGrpcServerInterceptor(observationRegistry);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"io.grpc.kotlin.AbstractCoroutineStub"})
    static class GrpcServerCoroutineStubConfiguration {
        GrpcServerCoroutineStubConfiguration() {
        }

        @Bean
        @Order(value=10)
        @GlobalServerInterceptor
        ObservationCoroutineContextServerInterceptor observationCoroutineGrpcServerInterceptor(ObservationRegistry observationRegistry) {
            return new ObservationCoroutineContextServerInterceptor(observationRegistry);
        }
    }
}

