/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server;

import io.grpc.ServerBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.grpc.server.ServerBuilderCustomizer;

public class ServerBuilderCustomizers {
    private final List<ServerBuilderCustomizer<?>> customizers;

    ServerBuilderCustomizers(List<? extends ServerBuilderCustomizer<?>> customizers) {
        this.customizers = customizers != null ? new ArrayList(customizers) : Collections.emptyList();
    }

    <T extends ServerBuilder<?>> T customize(T serverBuilder) {
        ((LambdaSafe.Callbacks)LambdaSafe.callbacks(ServerBuilderCustomizer.class, this.customizers, serverBuilder, (Object[])new Object[0]).withLogger(ServerBuilderCustomizers.class)).invoke(customizer -> customizer.customize(serverBuilder));
        return serverBuilder;
    }
}

