/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.health;

import java.time.Duration;
import java.time.Instant;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerBuilder;
import org.springframework.grpc.autoconfigure.server.health.ActuatorHealthAdapter;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;

class ActuatorHealthAdapterInvoker
implements InitializingBean,
DisposableBean {
    private final ActuatorHealthAdapter healthAdapter;
    private final SimpleAsyncTaskScheduler taskScheduler;
    private final Duration updateInitialDelay;
    private final Duration updateFixedRate;

    ActuatorHealthAdapterInvoker(ActuatorHealthAdapter healthAdapter, SimpleAsyncTaskSchedulerBuilder schedulerBuilder, Duration updateInitialDelay, Duration updateFixedRate) {
        this.healthAdapter = healthAdapter;
        this.taskScheduler = schedulerBuilder.threadNamePrefix("healthAdapter-").build();
        this.updateInitialDelay = updateInitialDelay;
        this.updateFixedRate = updateFixedRate;
    }

    public void afterPropertiesSet() {
        this.taskScheduler.scheduleAtFixedRate(this::updateHealthStatus, Instant.now().plus(this.updateInitialDelay), this.updateFixedRate);
    }

    public void destroy() {
        this.taskScheduler.close();
    }

    void updateHealthStatus() {
        this.healthAdapter.updateHealthStatus();
    }
}

