/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.security;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.OAuth2ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.server.GlobalServerInterceptor;
import org.springframework.grpc.server.security.AuthenticationProcessInterceptor;
import org.springframework.grpc.server.security.GrpcSecurity;
import org.springframework.security.config.Customizer;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.SpringOpaqueTokenIntrospector;

@Configuration(proxyBeanMethods=false)
class OAuth2ResourceServerOpaqueTokenConfiguration {
    OAuth2ResourceServerOpaqueTokenConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={AuthenticationProcessInterceptor.class})
    static class OAuth2SecurityFilterChainConfiguration {
        OAuth2SecurityFilterChainConfiguration() {
        }

        @Bean
        @ConditionalOnBean(value={OpaqueTokenIntrospector.class})
        @GlobalServerInterceptor
        AuthenticationProcessInterceptor opaqueTokenAuthenticationProcessInterceptor(GrpcSecurity http) throws Exception {
            http.authorizeRequests(requests -> requests.allRequests().authenticated());
            http.oauth2ResourceServer(resourceServer -> resourceServer.opaqueToken(Customizer.withDefaults()));
            return (AuthenticationProcessInterceptor)http.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={OpaqueTokenIntrospector.class})
    static class OpaqueTokenIntrospectionClientConfiguration {
        OpaqueTokenIntrospectionClientConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.security.oauth2.resourceserver.opaquetoken.introspection-uri"})
        SpringOpaqueTokenIntrospector blockingOpaqueTokenIntrospector(OAuth2ResourceServerProperties properties) {
            OAuth2ResourceServerProperties.Opaquetoken opaqueToken = properties.getOpaquetoken();
            return SpringOpaqueTokenIntrospector.withIntrospectionUri((String)opaqueToken.getIntrospectionUri()).clientId(opaqueToken.getClientId()).clientSecret(opaqueToken.getClientSecret()).build();
        }
    }
}

