/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.exception;

import io.grpc.Grpc;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.grpc.server.GlobalServerInterceptor;
import org.springframework.grpc.server.exception.CompositeGrpcExceptionHandler;
import org.springframework.grpc.server.exception.GrpcExceptionHandler;
import org.springframework.grpc.server.exception.GrpcExceptionHandlerInterceptor;

@AutoConfiguration
@ConditionalOnClass(value={Grpc.class})
@ConditionalOnBean(value={GrpcExceptionHandler.class})
@ConditionalOnMissingBean(value={GrpcExceptionHandlerInterceptor.class})
@ConditionalOnProperty(prefix="spring.grpc.server.exception-handler", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class GrpcExceptionHandlerAutoConfiguration {
    @GlobalServerInterceptor
    @Bean
    public GrpcExceptionHandlerInterceptor globalExceptionHandlerInterceptor(ObjectProvider<GrpcExceptionHandler> exceptionHandler) {
        return new GrpcExceptionHandlerInterceptor((GrpcExceptionHandler)new CompositeGrpcExceptionHandler(exceptionHandler.orderedStream().collect(Collectors.toList()).toArray(new GrpcExceptionHandler[0])));
    }
}

