/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.security;

import io.grpc.ServerBuilder;
import io.grpc.internal.GrpcUtil;
import java.util.concurrent.Executor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.autoconfigure.server.GrpcServerFactoryAutoConfiguration;
import org.springframework.grpc.autoconfigure.server.exception.GrpcExceptionHandlerAutoConfiguration;
import org.springframework.grpc.server.GlobalServerInterceptor;
import org.springframework.grpc.server.ServerBuilderCustomizer;
import org.springframework.grpc.server.exception.GrpcExceptionHandler;
import org.springframework.grpc.server.security.SecurityContextServerInterceptor;
import org.springframework.grpc.server.security.SecurityGrpcExceptionHandler;
import org.springframework.security.concurrent.DelegatingSecurityContextExecutor;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.web.SecurityFilterChain;

@ConditionalOnClass(value={ObjectPostProcessor.class})
@AutoConfiguration(before={GrpcExceptionHandlerAutoConfiguration.class}, after={SecurityAutoConfiguration.class})
public class GrpcSecurityAutoConfiguration {

    @ConditionalOnBean(value={SecurityFilterChain.class})
    @Configuration(proxyBeanMethods=false)
    @Conditional(value={GrpcServerFactoryAutoConfiguration.OnGrpcServletCondition.class})
    static class GrpcSecurityConfigurerAutoConfiguration {
        GrpcSecurityConfigurerAutoConfiguration() {
        }

        @Bean
        @GlobalServerInterceptor
        public SecurityContextServerInterceptor securityContextInterceptor() {
            return new SecurityContextServerInterceptor();
        }

        @Bean
        public <T extends ServerBuilder<T>> ServerBuilderCustomizer<T> securityContextExecutorCustomizer() {
            return serverBuilder -> serverBuilder.executor((Executor)new DelegatingSecurityContextExecutor((Executor)GrpcUtil.SHARED_CHANNEL_EXECUTOR.create()));
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class ExceptionHandlerAutoConfiguration {
        ExceptionHandlerAutoConfiguration() {
        }

        @Bean
        public GrpcExceptionHandler accessExceptionHandler() {
            return new SecurityGrpcExceptionHandler();
        }
    }
}

