/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import java.util.ArrayList;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.grpc.autoconfigure.client.GrpcClientProperties;
import org.springframework.grpc.client.BlockingStubFactory;
import org.springframework.grpc.client.EnableGrpcClients;
import org.springframework.grpc.client.GrpcClientRegistryCustomizer;
import org.springframework.grpc.client.GrpcClientRegistryPostProcessor;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={GrpcClientRegistryPostProcessor.class})
@EnableGrpcClients
public class ClientScanConfiguration {
    @Bean
    public GrpcClientRegistryCustomizer defaultGrpcClientRegistryCustomizer(BeanFactory beanFactory, Environment environment) {
        ArrayList packages = new ArrayList();
        if (AutoConfigurationPackages.has((BeanFactory)beanFactory)) {
            packages.addAll(AutoConfigurationPackages.get((BeanFactory)beanFactory));
        }
        Binder binder = Binder.get((Environment)environment);
        boolean hasDefaultChannel = binder.bind("spring.grpc.client.default-channel", GrpcClientProperties.ChannelConfig.class).isBound();
        return registry -> {
            if (hasDefaultChannel) {
                registry.channel("default").scan(BlockingStubFactory.class).packages(packages.toArray(new String[0]));
            }
        };
    }
}

