/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.security;

import org.springframework.context.ApplicationContext;
import org.springframework.grpc.autoconfigure.server.security.GrpcServletRequest;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GrpcDisableCsrfHttpConfigurer
extends AbstractHttpConfigurer<GrpcDisableCsrfHttpConfigurer, HttpSecurity> {
    public void init(HttpSecurity http) throws Exception {
        ApplicationContext context = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        if (context != null && context.getBeanNamesForType(GrpcServiceDiscoverer.class).length == 1 && this.isServletEnabledAndCsrfDisabled(context) && this.isCsrfConfigurerPresent(http)) {
            http.csrf(this::disable);
        }
    }

    private boolean isCsrfConfigurerPresent(HttpSecurity http) {
        return http.getConfigurer(CsrfConfigurer.class) != null;
    }

    private void disable(CsrfConfigurer<HttpSecurity> csrf) {
        csrf.requireCsrfProtectionMatcher((RequestMatcher)new AndRequestMatcher(new RequestMatcher[]{CsrfFilter.DEFAULT_CSRF_MATCHER, new NegatedRequestMatcher((RequestMatcher)GrpcServletRequest.all())}));
    }

    private boolean isServletEnabledAndCsrfDisabled(ApplicationContext context) {
        return (Boolean)context.getEnvironment().getProperty("spring.grpc.server.servlet.enabled", Boolean.class, (Object)true) != false && (Boolean)context.getEnvironment().getProperty("spring.grpc.server.security.csrf.enabled", Boolean.class, (Object)false) == false;
    }
}

