/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.boot.security.servlet.ApplicationContextRequestMatcher;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class GrpcServletRequest {
    private GrpcServletRequest() {
    }

    public static GrpcServletRequestMatcher all() {
        return new GrpcServletRequestMatcher();
    }

    public static final class GrpcServletRequestMatcher
    extends ApplicationContextRequestMatcher<GrpcServiceDiscoverer> {
        private final Set<String> exclusions;
        private volatile RequestMatcher delegate;

        private GrpcServletRequestMatcher() {
            this(new HashSet<String>());
        }

        private GrpcServletRequestMatcher(Set<String> exclusions) {
            super(GrpcServiceDiscoverer.class);
            this.exclusions = exclusions;
        }

        public GrpcServletRequestMatcher excluding(String ... rest) {
            return this.excluding(Set.of(rest));
        }

        public GrpcServletRequestMatcher excluding(Set<String> exclusions) {
            Assert.notNull(exclusions, (String)"Exclusions must not be null");
            LinkedHashSet<String> subset = new LinkedHashSet<String>(this.exclusions);
            subset.addAll(exclusions);
            return new GrpcServletRequestMatcher(subset);
        }

        protected void initialized(Supplier<GrpcServiceDiscoverer> context) {
            List<RequestMatcher> matchers = this.getDelegateMatchers(context.get()).toList();
            this.delegate = matchers.isEmpty() ? request -> false : new OrRequestMatcher(matchers);
        }

        protected boolean ignoreApplicationContext(WebApplicationContext context) {
            return context.getBeanNamesForType(GrpcServiceDiscoverer.class).length != 1;
        }

        private Stream<RequestMatcher> getDelegateMatchers(GrpcServiceDiscoverer context) {
            return this.getPatterns(context).map(AntPathRequestMatcher::new);
        }

        private Stream<String> getPatterns(GrpcServiceDiscoverer context) {
            return context.listServiceNames().stream().filter(service -> !this.exclusions.stream().anyMatch(type -> type.equals(service))).map(service -> "/" + service + "/**");
        }

        protected boolean matches(HttpServletRequest request, Supplier<GrpcServiceDiscoverer> context) {
            return this.delegate.matches(request);
        }
    }
}

