/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.security;

import io.grpc.ServerBuilder;
import io.grpc.internal.GrpcUtil;
import java.util.concurrent.Executor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.autoconfigure.server.GrpcServerFactoryAutoConfiguration;
import org.springframework.grpc.server.GlobalServerInterceptor;
import org.springframework.grpc.server.ServerBuilderCustomizer;
import org.springframework.grpc.server.security.SecurityContextServerInterceptor;
import org.springframework.security.concurrent.DelegatingSecurityContextExecutor;
import org.springframework.security.web.SecurityFilterChain;

@ConditionalOnBean(value={SecurityFilterChain.class})
@Conditional(value={GrpcServerFactoryAutoConfiguration.OnGrpcServletCondition.class})
@Configuration(proxyBeanMethods=false)
class GrpcServletSecurityConfigurerAutoConfiguration {
    GrpcServletSecurityConfigurerAutoConfiguration() {
    }

    @Bean
    @GlobalServerInterceptor
    public SecurityContextServerInterceptor securityContextInterceptor() {
        return new SecurityContextServerInterceptor();
    }

    @Bean
    public <T extends ServerBuilder<T>> ServerBuilderCustomizer<T> securityContextExecutorCustomizer() {
        return serverBuilder -> serverBuilder.executor((Executor)new DelegatingSecurityContextExecutor((Executor)GrpcUtil.SHARED_CHANNEL_EXECUTOR.create()));
    }
}

