/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.grpc.autoconfigure.client.GrpcClientProperties;
import org.springframework.grpc.client.GrpcChannelBuilderCustomizer;
import org.springframework.grpc.client.interceptor.DefaultDeadlineSetupClientInterceptor;
import org.springframework.util.unit.DataSize;

class ClientPropertiesChannelBuilderCustomizer<T extends ManagedChannelBuilder<T>>
implements GrpcChannelBuilderCustomizer<T> {
    private final GrpcClientProperties properties;

    ClientPropertiesChannelBuilderCustomizer(GrpcClientProperties properties) {
        this.properties = properties;
    }

    public void customize(String authority, T builder) {
        GrpcClientProperties.ChannelConfig channel = this.properties.getChannel(authority);
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        mapper.from((Object)channel.getUserAgent()).to(arg_0 -> builder.userAgent(arg_0));
        if (!authority.startsWith("unix:")) {
            mapper.from((Object)channel.getDefaultLoadBalancingPolicy()).to(arg_0 -> builder.defaultLoadBalancingPolicy(arg_0));
        }
        mapper.from((Object)channel.getMaxInboundMessageSize()).asInt(DataSize::toBytes).to(arg_0 -> builder.maxInboundMessageSize(arg_0));
        mapper.from((Object)channel.getMaxInboundMetadataSize()).asInt(DataSize::toBytes).to(arg_0 -> builder.maxInboundMetadataSize(arg_0));
        mapper.from((Object)channel.getKeepAliveTime()).to(this.durationProperty((arg_0, arg_1) -> builder.keepAliveTime(arg_0, arg_1)));
        mapper.from((Object)channel.getKeepAliveTimeout()).to(this.durationProperty((arg_0, arg_1) -> builder.keepAliveTimeout(arg_0, arg_1)));
        mapper.from((Object)channel.getIdleTimeout()).to(this.durationProperty((arg_0, arg_1) -> builder.idleTimeout(arg_0, arg_1)));
        mapper.from((Object)channel.isKeepAliveWithoutCalls()).to(arg_0 -> builder.keepAliveWithoutCalls(arg_0));
        if (channel.getHealth().isEnabled()) {
            String serviceNameToCheck = channel.getHealth().getServiceName() != null ? channel.getHealth().getServiceName() : "";
            Map<String, Map<String, String>> healthCheckConfig = Map.of("healthCheckConfig", Map.of("serviceName", serviceNameToCheck));
            builder.defaultServiceConfig(healthCheckConfig);
        }
        if (channel.getDefaultDeadline() != null && channel.getDefaultDeadline().toMillis() > 0L) {
            builder.intercept(new ClientInterceptor[]{new DefaultDeadlineSetupClientInterceptor(channel.getDefaultDeadline())});
        }
    }

    Consumer<Duration> durationProperty(BiConsumer<Long, TimeUnit> setter) {
        return duration -> setter.accept(duration.toNanos(), TimeUnit.NANOSECONDS);
    }
}

