/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.grpc.autoconfigure.client.GrpcClientProperties;
import org.springframework.grpc.client.AbstractGrpcClientRegistrar;
import org.springframework.grpc.client.BlockingStubFactory;
import org.springframework.grpc.client.GrpcClientFactory;
import org.springframework.grpc.client.GrpcClientFactoryPostProcessor;
import org.springframework.grpc.client.ImportGrpcClients;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={GrpcClientFactoryPostProcessor.class})
@ImportGrpcClients
@Import(value={DefaultGrpcClientRegistrations.class})
public class ClientScanConfiguration {

    static class DefaultGrpcClientRegistrations
    extends AbstractGrpcClientRegistrar
    implements EnvironmentAware,
    BeanFactoryAware {
        private Environment environment;
        private BeanFactory beanFactory;

        DefaultGrpcClientRegistrations() {
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        protected GrpcClientFactory.GrpcClientRegistrationSpec[] collect(AnnotationMetadata meta) {
            Binder binder = Binder.get((Environment)this.environment);
            boolean hasDefaultChannel = binder.bind("spring.grpc.client.default-channel", GrpcClientProperties.ChannelConfig.class).isBound();
            if (hasDefaultChannel) {
                ArrayList packages = new ArrayList();
                if (AutoConfigurationPackages.has((BeanFactory)this.beanFactory)) {
                    packages.addAll(AutoConfigurationPackages.get((BeanFactory)this.beanFactory));
                }
                return new GrpcClientFactory.GrpcClientRegistrationSpec[]{GrpcClientFactory.GrpcClientRegistrationSpec.of((String)"default").factory(BlockingStubFactory.class).packages(packages.toArray(new String[0]))};
            }
            return new GrpcClientFactory.GrpcClientRegistrationSpec[0];
        }
    }
}

