/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannelBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.grpc.autoconfigure.client.ChannelBuilderCustomizers;
import org.springframework.grpc.autoconfigure.client.ClientInterceptorsConfiguration;
import org.springframework.grpc.autoconfigure.client.ClientPropertiesChannelBuilderCustomizer;
import org.springframework.grpc.autoconfigure.client.ClientScanConfiguration;
import org.springframework.grpc.autoconfigure.client.ConditionalOnGrpcClientEnabled;
import org.springframework.grpc.autoconfigure.client.GrpcChannelFactoryConfigurations;
import org.springframework.grpc.autoconfigure.client.GrpcClientProperties;
import org.springframework.grpc.autoconfigure.client.NamedChannelCredentialsProvider;
import org.springframework.grpc.autoconfigure.common.codec.GrpcCodecConfiguration;
import org.springframework.grpc.client.ChannelCredentialsProvider;
import org.springframework.grpc.client.GrpcChannelBuilderCustomizer;

@AutoConfiguration
@ConditionalOnGrpcClientEnabled
@EnableConfigurationProperties(value={GrpcClientProperties.class})
@Import(value={GrpcCodecConfiguration.class, ClientInterceptorsConfiguration.class, GrpcChannelFactoryConfigurations.ShadedNettyChannelFactoryConfiguration.class, GrpcChannelFactoryConfigurations.NettyChannelFactoryConfiguration.class, ClientScanConfiguration.class})
public class GrpcClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ChannelCredentialsProvider.class})
    NamedChannelCredentialsProvider channelCredentialsProvider(SslBundles bundles, GrpcClientProperties properties) {
        return new NamedChannelCredentialsProvider(bundles, properties);
    }

    @Bean
    <T extends ManagedChannelBuilder<T>> GrpcChannelBuilderCustomizer<T> clientPropertiesChannelCustomizer(GrpcClientProperties properties) {
        return new ClientPropertiesChannelBuilderCustomizer(properties);
    }

    @ConditionalOnBean(value={CompressorRegistry.class})
    @Bean
    <T extends ManagedChannelBuilder<T>> GrpcChannelBuilderCustomizer<T> compressionClientCustomizer(CompressorRegistry registry) {
        return (name, builder) -> builder.compressorRegistry(registry);
    }

    @ConditionalOnBean(value={DecompressorRegistry.class})
    @Bean
    <T extends ManagedChannelBuilder<T>> GrpcChannelBuilderCustomizer<T> decompressionClientCustomizer(DecompressorRegistry registry) {
        return (name, builder) -> builder.decompressorRegistry(registry);
    }

    @ConditionalOnMissingBean
    @Bean
    ChannelBuilderCustomizers channelBuilderCustomizers(ObjectProvider<GrpcChannelBuilderCustomizer<?>> customizers) {
        return new ChannelBuilderCustomizers(customizers.orderedStream().toList());
    }
}

