/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server;

import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.autoconfigure.server.GrpcServerProperties;
import org.springframework.grpc.autoconfigure.server.NettyServerFactoryPropertyMapper;
import org.springframework.grpc.autoconfigure.server.ServerBuilderCustomizers;
import org.springframework.grpc.autoconfigure.server.ShadedNettyServerFactoryPropertyMapper;
import org.springframework.grpc.server.GrpcServerFactory;
import org.springframework.grpc.server.NettyGrpcServerFactory;
import org.springframework.grpc.server.ServerBuilderCustomizer;
import org.springframework.grpc.server.ShadedNettyGrpcServerFactory;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;

class GrpcServerFactoryConfigurations {
    GrpcServerFactoryConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={io.grpc.netty.NettyServerBuilder.class})
    @ConditionalOnMissingBean(value={GrpcServerFactory.class})
    @EnableConfigurationProperties(value={GrpcServerProperties.class})
    static class NettyServerFactoryConfiguration {
        NettyServerFactoryConfiguration() {
        }

        @Bean
        NettyGrpcServerFactory nettyGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer grpcServicesDiscoverer, ServerBuilderCustomizers serverBuilderCustomizers, SslBundles bundles) {
            NettyServerFactoryPropertyMapper mapper = new NettyServerFactoryPropertyMapper(properties);
            List<ServerBuilderCustomizer> builderCustomizers = List.of(mapper::customizeServerBuilder, serverBuilderCustomizers::customize);
            KeyManagerFactory keyManager = null;
            TrustManagerFactory trustManager = null;
            if (properties.getSsl().isEnabled()) {
                SslBundle bundle = bundles.getBundle(properties.getSsl().getBundle());
                keyManager = bundle.getManagers().getKeyManagerFactory();
                trustManager = properties.getSsl().isSecure() ? bundle.getManagers().getTrustManagerFactory() : io.netty.handler.ssl.util.InsecureTrustManagerFactory.INSTANCE;
            }
            NettyGrpcServerFactory factory = new NettyGrpcServerFactory(properties.getAddress(), builderCustomizers, keyManager, trustManager, properties.getSsl().getClientAuth());
            grpcServicesDiscoverer.findServices().forEach(arg_0 -> ((NettyGrpcServerFactory)factory).addService(arg_0));
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={NettyServerBuilder.class})
    @ConditionalOnMissingBean(value={GrpcServerFactory.class})
    @EnableConfigurationProperties(value={GrpcServerProperties.class})
    static class ShadedNettyServerFactoryConfiguration {
        ShadedNettyServerFactoryConfiguration() {
        }

        @Bean
        ShadedNettyGrpcServerFactory shadedNettyGrpcServerFactory(GrpcServerProperties properties, GrpcServiceDiscoverer grpcServicesDiscoverer, ServerBuilderCustomizers serverBuilderCustomizers, SslBundles bundles) {
            ShadedNettyServerFactoryPropertyMapper mapper = new ShadedNettyServerFactoryPropertyMapper(properties);
            List<ServerBuilderCustomizer> builderCustomizers = List.of(mapper::customizeServerBuilder, serverBuilderCustomizers::customize);
            KeyManagerFactory keyManager = null;
            TrustManagerFactory trustManager = null;
            if (properties.getSsl().isEnabled()) {
                SslBundle bundle = bundles.getBundle(properties.getSsl().getBundle());
                keyManager = bundle.getManagers().getKeyManagerFactory();
                trustManager = properties.getSsl().isSecure() ? bundle.getManagers().getTrustManagerFactory() : InsecureTrustManagerFactory.INSTANCE;
            }
            ShadedNettyGrpcServerFactory factory = new ShadedNettyGrpcServerFactory(properties.getAddress(), builderCustomizers, keyManager, trustManager, properties.getSsl().getClientAuth());
            grpcServicesDiscoverer.findServices().forEach(arg_0 -> ((ShadedNettyGrpcServerFactory)factory).addService(arg_0));
            return factory;
        }
    }
}

