/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class ServletEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final boolean SERVLET_AVAILABLE = ClassUtils.isPresent((String)"io.grpc.servlet.jakarta.GrpcServlet", null);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (SERVLET_AVAILABLE) {
            environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("grpc-servlet", Map.of("server.http2.enabled", "true")));
        }
    }
}

