/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import io.grpc.netty.NettyChannelBuilder;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.autoconfigure.client.ChannelBuilderCustomizers;
import org.springframework.grpc.autoconfigure.client.GrpcClientProperties;
import org.springframework.grpc.client.ChannelCredentialsProvider;
import org.springframework.grpc.client.ClientInterceptorsConfigurer;
import org.springframework.grpc.client.GrpcChannelBuilderCustomizer;
import org.springframework.grpc.client.GrpcChannelFactory;
import org.springframework.grpc.client.NettyGrpcChannelFactory;
import org.springframework.grpc.client.ShadedNettyGrpcChannelFactory;
import org.springframework.grpc.client.VirtualTargets;

class GrpcChannelFactoryConfigurations {
    GrpcChannelFactoryConfigurations() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={NettyChannelBuilder.class})
    @ConditionalOnMissingBean(value={GrpcChannelFactory.class})
    @EnableConfigurationProperties(value={GrpcClientProperties.class})
    static class NettyChannelFactoryConfiguration {
        NettyChannelFactoryConfiguration() {
        }

        @Bean
        NettyGrpcChannelFactory nettyGrpcChannelFactory(GrpcClientProperties properties, ChannelBuilderCustomizers channelBuilderCustomizers, ClientInterceptorsConfigurer interceptorsConfigurer, ChannelCredentialsProvider credentials) {
            List<GrpcChannelBuilderCustomizer> builderCustomizers = List.of(channelBuilderCustomizers::customize);
            NettyGrpcChannelFactory factory = new NettyGrpcChannelFactory(builderCustomizers, interceptorsConfigurer);
            factory.setCredentialsProvider(credentials);
            factory.setVirtualTargets((VirtualTargets)properties);
            return factory;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder.class})
    @ConditionalOnMissingBean(value={GrpcChannelFactory.class})
    @EnableConfigurationProperties(value={GrpcClientProperties.class})
    static class ShadedNettyChannelFactoryConfiguration {
        ShadedNettyChannelFactoryConfiguration() {
        }

        @Bean
        ShadedNettyGrpcChannelFactory shadedNettyGrpcChannelFactory(GrpcClientProperties properties, ChannelBuilderCustomizers channelBuilderCustomizers, ClientInterceptorsConfigurer interceptorsConfigurer, ChannelCredentialsProvider credentials) {
            List<GrpcChannelBuilderCustomizer> builderCustomizers = List.of(channelBuilderCustomizers::customize);
            ShadedNettyGrpcChannelFactory factory = new ShadedNettyGrpcChannelFactory(builderCustomizers, interceptorsConfigurer);
            factory.setCredentialsProvider(credentials);
            factory.setVirtualTargets((VirtualTargets)properties);
            return factory;
        }
    }
}

