/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server;

import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ServerBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.grpc.autoconfigure.common.codec.GrpcCodecConfiguration;
import org.springframework.grpc.autoconfigure.server.ConditionalOnGrpcServerEnabled;
import org.springframework.grpc.autoconfigure.server.GrpcServerFactoryAutoConfiguration;
import org.springframework.grpc.autoconfigure.server.GrpcServerProperties;
import org.springframework.grpc.autoconfigure.server.ServerBuilderCustomizers;
import org.springframework.grpc.server.ServerBuilderCustomizer;
import org.springframework.grpc.server.exception.ReactiveStubBeanDefinitionRegistrar;
import org.springframework.grpc.server.service.DefaultGrpcServiceConfigurer;
import org.springframework.grpc.server.service.DefaultGrpcServiceDiscoverer;
import org.springframework.grpc.server.service.GrpcServiceConfigurer;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;

@AutoConfiguration(after={GrpcServerFactoryAutoConfiguration.class})
@ConditionalOnGrpcServerEnabled
@ConditionalOnBean(value={BindableService.class})
@EnableConfigurationProperties(value={GrpcServerProperties.class})
@Import(value={GrpcCodecConfiguration.class})
public class GrpcServerAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    ServerBuilderCustomizers serverBuilderCustomizers(ObjectProvider<ServerBuilderCustomizer<?>> customizers) {
        return new ServerBuilderCustomizers(customizers.orderedStream().toList());
    }

    @ConditionalOnMissingBean(value={GrpcServiceConfigurer.class})
    @Bean
    DefaultGrpcServiceConfigurer grpcServiceConfigurer(ApplicationContext applicationContext) {
        return new DefaultGrpcServiceConfigurer(applicationContext);
    }

    @ConditionalOnMissingBean(value={GrpcServiceDiscoverer.class})
    @Bean
    DefaultGrpcServiceDiscoverer grpcServiceDiscoverer(ApplicationContext applicationContext) {
        return new DefaultGrpcServiceDiscoverer(applicationContext);
    }

    @ConditionalOnBean(value={CompressorRegistry.class})
    @Bean
    <T extends ServerBuilder<T>> ServerBuilderCustomizer<T> compressionServerConfigurer(CompressorRegistry registry) {
        return builder -> builder.compressorRegistry(registry);
    }

    @ConditionalOnBean(value={DecompressorRegistry.class})
    @Bean
    <T extends ServerBuilder<T>> ServerBuilderCustomizer<T> decompressionServerConfigurer(DecompressorRegistry registry) {
        return builder -> builder.decompressorRegistry(registry);
    }

    @ConditionalOnClass(name={"com.salesforce.reactivegrpc.common.Function"})
    @Configuration
    @Import(value={ReactiveStubBeanDefinitionRegistrar.class})
    static class ReactiveStubConfiguration {
        ReactiveStubConfiguration() {
        }
    }
}

