/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server;

import io.grpc.TlsServerCredentials;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DataSizeUnit;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.grpc.internal.GrpcUtils;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

@ConfigurationProperties(prefix="spring.grpc.server")
public class GrpcServerProperties {
    public static final String ANY_IP_ADDRESS = "*";
    private String host = "*";
    private int port = GrpcUtils.DEFAULT_PORT;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration shutdownGracePeriod = Duration.ofSeconds(30L);
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMessageSize = DataSize.ofBytes((long)0x400000L);
    @DataSizeUnit(value=DataUnit.BYTES)
    private DataSize maxInboundMetadataSize = DataSize.ofBytes((long)8192L);
    private final Health health = new Health();
    private final KeepAlive keepAlive = new KeepAlive();
    private final Inprocess inprocess = new Inprocess();
    private String address;
    private final Ssl ssl = new Ssl();

    public String getAddress() {
        return this.address == null ? this.host + ":" + this.port : this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (this.address != null) {
            throw new IllegalStateException("Cannot set host when address is already set");
        }
        this.host = host;
    }

    public int getPort() {
        if (this.address != null) {
            return GrpcUtils.getPort((String)this.address);
        }
        return this.port;
    }

    public void setPort(int port) {
        if (this.address != null) {
            throw new IllegalStateException("Cannot set port when address is already set");
        }
        this.port = port;
    }

    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public void setShutdownGracePeriod(Duration shutdownGracePeriod) {
        this.shutdownGracePeriod = shutdownGracePeriod;
    }

    public DataSize getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public DataSize getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
        this.maxInboundMetadataSize = maxInboundMetadataSize;
    }

    public Health getHealth() {
        return this.health;
    }

    public KeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    public Inprocess getInprocess() {
        return this.inprocess;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public static class Health {
        private Boolean enabled = true;
        private final ActuatorAdapt actuator = new ActuatorAdapt();

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public ActuatorAdapt getActuator() {
            return this.actuator;
        }
    }

    public static class KeepAlive {
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration time = Duration.ofHours(2L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration timeout = Duration.ofSeconds(20L);
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration maxIdle = null;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration maxAge = null;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration maxAgeGrace = null;
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration permitTime = Duration.ofMinutes(5L);
        private boolean permitWithoutCalls = false;

        public Duration getTime() {
            return this.time;
        }

        public void setTime(Duration time) {
            this.time = time;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        public Duration getMaxIdle() {
            return this.maxIdle;
        }

        public void setMaxIdle(Duration maxIdle) {
            this.maxIdle = maxIdle;
        }

        public Duration getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(Duration maxAge) {
            this.maxAge = maxAge;
        }

        public Duration getMaxAgeGrace() {
            return this.maxAgeGrace;
        }

        public void setMaxAgeGrace(Duration maxAgeGrace) {
            this.maxAgeGrace = maxAgeGrace;
        }

        public Duration getPermitTime() {
            return this.permitTime;
        }

        public void setPermitTime(Duration permitTime) {
            this.permitTime = permitTime;
        }

        public boolean isPermitWithoutCalls() {
            return this.permitWithoutCalls;
        }

        public void setPermitWithoutCalls(boolean permitWithoutCalls) {
            this.permitWithoutCalls = permitWithoutCalls;
        }
    }

    public static class Inprocess {
        private String name;
        private Boolean exclusive;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Boolean getExclusive() {
            return this.exclusive;
        }

        public void setExclusive(Boolean exclusive) {
            this.exclusive = exclusive;
        }
    }

    public static class Ssl {
        private Boolean enabled;
        private TlsServerCredentials.ClientAuth clientAuth = TlsServerCredentials.ClientAuth.NONE;
        private String bundle;
        private boolean secure = true;

        public boolean isEnabled() {
            return this.enabled != null ? this.enabled : this.bundle != null;
        }

        public void copyDefaultsFrom(Ssl config) {
            if (this.enabled == null) {
                this.enabled = config.enabled;
            }
            if (this.bundle == null) {
                this.bundle = config.bundle;
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getBundle() {
            return this.bundle;
        }

        public void setBundle(String bundle) {
            this.bundle = bundle;
        }

        public void setClientAuth(TlsServerCredentials.ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        public TlsServerCredentials.ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public boolean isSecure() {
            return this.secure;
        }
    }

    public static class ActuatorAdapt {
        private Boolean enabled = true;
        private Boolean updateOverallHealth = true;
        private Duration updateRate = Duration.ofSeconds(5L);
        private Duration updateInitialDelay = Duration.ofSeconds(5L);
        private List<String> healthIndicatorPaths = new ArrayList<String>();

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Boolean getUpdateOverallHealth() {
            return this.updateOverallHealth;
        }

        public void setUpdateOverallHealth(Boolean updateOverallHealth) {
            this.updateOverallHealth = updateOverallHealth;
        }

        public Duration getUpdateRate() {
            return this.updateRate;
        }

        public void setUpdateRate(Duration updateRate) {
            this.updateRate = updateRate;
        }

        public Duration getUpdateInitialDelay() {
            return this.updateInitialDelay;
        }

        public void setUpdateInitialDelay(Duration updateInitialDelay) {
            this.updateInitialDelay = updateInitialDelay;
        }

        public List<String> getHealthIndicatorPaths() {
            return this.healthIndicatorPaths;
        }

        public void setHealthIndicatorPaths(List<String> healthIndicatorPaths) {
            this.healthIndicatorPaths = healthIndicatorPaths;
        }
    }
}

