/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.security;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.boot.security.reactive.ApplicationContextServerWebExchangeMatcher;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GrpcReactiveRequest {
    private GrpcReactiveRequest() {
    }

    public static GrpcReactiveRequestMatcher all() {
        return new GrpcReactiveRequestMatcher();
    }

    public static final class GrpcReactiveRequestMatcher
    extends ApplicationContextServerWebExchangeMatcher<GrpcServiceDiscoverer> {
        private final Set<String> exclusions;
        private volatile ServerWebExchangeMatcher delegate;

        private GrpcReactiveRequestMatcher() {
            this(new HashSet<String>());
        }

        private GrpcReactiveRequestMatcher(Set<String> exclusions) {
            super(GrpcServiceDiscoverer.class);
            this.exclusions = exclusions;
        }

        public GrpcReactiveRequestMatcher excluding(String ... rest) {
            return this.excluding(Set.of(rest));
        }

        public GrpcReactiveRequestMatcher excluding(Set<String> exclusions) {
            Assert.notNull(exclusions, (String)"Exclusions must not be null");
            LinkedHashSet<String> subset = new LinkedHashSet<String>(this.exclusions);
            subset.addAll(exclusions);
            return new GrpcReactiveRequestMatcher(subset);
        }

        protected void initialized(Supplier<GrpcServiceDiscoverer> context) {
            List<ServerWebExchangeMatcher> matchers = this.getDelegateMatchers(context.get()).toList();
            this.delegate = matchers.isEmpty() ? request -> ServerWebExchangeMatcher.MatchResult.notMatch() : new OrServerWebExchangeMatcher(matchers);
        }

        private Stream<ServerWebExchangeMatcher> getDelegateMatchers(GrpcServiceDiscoverer context) {
            return this.getPatterns(context).map(PathPatternParserServerWebExchangeMatcher::new);
        }

        private Stream<String> getPatterns(GrpcServiceDiscoverer context) {
            return context.listServiceNames().stream().filter(service -> !this.exclusions.stream().anyMatch(type -> type.equals(service))).map(service -> "/" + service + "/**");
        }

        protected Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange, Supplier<GrpcServiceDiscoverer> context) {
            return this.delegate.matches(exchange);
        }
    }
}

