/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.test;

import io.grpc.BindableService;
import io.grpc.inprocess.InProcessServerBuilder;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.grpc.autoconfigure.client.ClientInterceptorsConfiguration;
import org.springframework.grpc.autoconfigure.client.GrpcClientAutoConfiguration;
import org.springframework.grpc.autoconfigure.server.GrpcServerFactoryAutoConfiguration;
import org.springframework.grpc.client.ClientInterceptorsConfigurer;
import org.springframework.grpc.server.ServerBuilderCustomizer;
import org.springframework.grpc.server.service.GrpcServiceDiscoverer;
import org.springframework.grpc.test.InProcessGrpcChannelFactory;
import org.springframework.grpc.test.InProcessGrpcServerFactory;

@AutoConfiguration(before={GrpcServerFactoryAutoConfiguration.class, GrpcClientAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.grpc.inprocess", name={"enabled"}, havingValue="true")
@ConditionalOnClass(value={BindableService.class})
@Import(value={ClientInterceptorsConfiguration.class})
public class InProcessGrpcServerFactoryAutoConfiguration {
    private final String address = InProcessServerBuilder.generateName();

    @Bean
    @ConditionalOnBean(value={BindableService.class})
    InProcessGrpcServerFactory grpcServerFactory(GrpcServiceDiscoverer grpcServicesDiscoverer, List<ServerBuilderCustomizer<InProcessServerBuilder>> customizers) {
        InProcessGrpcServerFactory factory = new InProcessGrpcServerFactory(this.address, customizers);
        grpcServicesDiscoverer.findServices().forEach(arg_0 -> ((InProcessGrpcServerFactory)factory).addService(arg_0));
        return factory;
    }

    @Bean
    InProcessGrpcChannelFactory grpcChannelFactory(ClientInterceptorsConfigurer interceptorsConfigurer) {
        InProcessGrpcChannelFactory factory = new InProcessGrpcChannelFactory(interceptorsConfigurer);
        factory.setVirtualTargets(path -> this.address);
        return factory;
    }
}

