/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.test;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationAotProcessor;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.NativeDetector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.grpc.test.AutoConfigureInProcessTransport;

public class InProcessTransportEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!EnablementDeducer.inTest(Thread.currentThread())) {
            return;
        }
        if (AnnotationUtils.findAnnotation((Class)application.getMainApplicationClass(), AutoConfigureInProcessTransport.class) == null) {
            return;
        }
        MapPropertySource inProcessTransportPropertySource = new MapPropertySource("inProcessTransportPropertySource", Collections.singletonMap("spring.grpc.inprocess.enabled", "true"));
        environment.getPropertySources().addFirst((PropertySource)inProcessTransportPropertySource);
    }

    static final class EnablementDeducer {
        private static final Set<String> INCLUDED_STACK_ELEMENTS;

        private EnablementDeducer() {
        }

        public static boolean inTest(Thread thread) {
            if (NativeDetector.inNativeImage()) {
                return false;
            }
            for (StackTraceElement element : thread.getStackTrace()) {
                if (!EnablementDeducer.isIncludedStackElement(element)) continue;
                return true;
            }
            return false;
        }

        private static boolean isIncludedStackElement(StackTraceElement element) {
            for (String included : INCLUDED_STACK_ELEMENTS) {
                if (!element.getClassName().startsWith(included)) continue;
                return true;
            }
            return false;
        }

        static {
            LinkedHashSet<String> included = new LinkedHashSet<String>();
            included.add("org.junit.runners.");
            included.add("org.junit.platform.");
            included.add("org.springframework.boot.test.");
            included.add(SpringApplicationAotProcessor.class.getName());
            included.add("cucumber.runtime.");
            INCLUDED_STACK_ELEMENTS = Collections.unmodifiableSet(included);
        }
    }
}

