/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;

public class TypeConstrainedMappingJackson2HttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    private final Class<?> type;

    public TypeConstrainedMappingJackson2HttpMessageConverter(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        this.type = type;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.type.isAssignableFrom(clazz) && super.canRead(clazz, mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.type.isAssignableFrom(clazz) && super.canWrite(clazz, mediaType);
    }
}

