/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.util.Assert;

public final class TemplateVariables
implements Iterable<TemplateVariable>,
Serializable {
    public static TemplateVariables NONE = new TemplateVariables(new TemplateVariable[0]);
    private static final long serialVersionUID = -7736592281223783079L;
    private final List<TemplateVariable> variables;

    public TemplateVariables(TemplateVariable ... variables) {
        this(Arrays.asList(variables));
    }

    public TemplateVariables(List<TemplateVariable> variables) {
        Assert.notNull(variables, (String)"Template variables must not be null!");
        this.variables = Collections.unmodifiableList(variables);
    }

    public TemplateVariables concat(TemplateVariable ... variables) {
        return this.concat(Arrays.asList(variables));
    }

    public TemplateVariables concat(Collection<TemplateVariable> variables) {
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>(this.variables.size() + variables.size());
        result.addAll(this.variables);
        for (TemplateVariable variable : variables) {
            if (this.containsEquivalentFor(variable)) continue;
            result.add(variable);
        }
        return new TemplateVariables(result);
    }

    public TemplateVariables concat(TemplateVariables variables) {
        return this.concat(variables.variables);
    }

    public List<TemplateVariable> asList() {
        return this.variables;
    }

    private boolean containsEquivalentFor(TemplateVariable candidate) {
        for (TemplateVariable variable : this.variables) {
            if (!variable.isEquivalent(candidate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<TemplateVariable> iterator() {
        return this.variables.iterator();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean appended) {
        if (this.variables.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        TemplateVariable previous = null;
        for (TemplateVariable variable : this.variables) {
            TemplateVariable.VariableType type = variable.getType();
            TemplateVariable.VariableType variableType = type = appended && type.equals((Object)TemplateVariable.VariableType.REQUEST_PARAM) ? TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED : type;
            if (previous == null) {
                builder.append("{").append(type.toString());
            } else if (!previous.isCombinable(variable)) {
                builder.append("}{").append(type.toString());
            } else {
                builder.append(",");
            }
            previous = variable;
            builder.append(variable.getName());
        }
        return builder.append("}").toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TemplateVariables)) {
            return false;
        }
        TemplateVariables that = (TemplateVariables)obj;
        return this.variables.equals(that.variables);
    }

    public int hashCode() {
        return this.variables.hashCode();
    }
}

