/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.springframework.util.Assert;

@XmlType(name="link", namespace="http://www.w3.org/2005/Atom")
public class Link
implements Serializable {
    private static final long serialVersionUID = -9037755944661782121L;
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final String REL_SELF = "self";
    public static final String REL_FIRST = "first";
    public static final String REL_PREVIOUS = "previous";
    public static final String REL_NEXT = "next";
    public static final String REL_LAST = "last";
    @XmlAttribute
    private String rel;
    @XmlAttribute
    private String href;

    public Link(String href) {
        this(href, REL_SELF);
    }

    public Link(String href, String rel) {
        Assert.hasText((String)href, (String)"Href must not be null or empty!");
        Assert.hasText((String)rel, (String)"Rel must not be null or empty!");
        this.href = href;
        this.rel = rel;
    }

    protected Link() {
    }

    public String getHref() {
        return this.href;
    }

    public String getRel() {
        return this.rel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link that = (Link)obj;
        return this.href.equals(that.href) && this.rel.equals(that.rel);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.href.hashCode();
        return result += 31 * this.rel.hashCode();
    }

    public String toString() {
        return String.format("{ rel : %s, href : %s }", this.rel, this.href);
    }
}

