/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Map;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsDocument;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilder;
import org.springframework.lang.Nullable;

class HalFormsSerializers {
    HalFormsSerializers() {
    }

    static class HalFormsCollectionModelSerializer
    extends ContainerSerializer<CollectionModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -3601146866067500734L;
        private final BeanProperty property;
        private final Jackson2HalModule.EmbeddedMapper embeddedMapper;
        private final HalFormsTemplateBuilder customizations;

        HalFormsCollectionModelSerializer(HalFormsTemplateBuilder customizations, @Nullable BeanProperty property, Jackson2HalModule.EmbeddedMapper embeddedMapper) {
            super(CollectionModel.class, false);
            this.property = property;
            this.embeddedMapper = embeddedMapper;
            this.customizations = customizations;
        }

        HalFormsCollectionModelSerializer(HalFormsTemplateBuilder customizations, Jackson2HalModule.EmbeddedMapper embeddedMapper) {
            this(customizations, null, embeddedMapper);
        }

        public void serialize(CollectionModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            Map<HalLinkRelation, Object> embeddeds = this.embeddedMapper.map(value);
            HalFormsDocument<?> doc = value instanceof PagedModel ? HalFormsDocument.empty().withEmbedded(embeddeds).withPageMetadata(((PagedModel)value).getMetadata()).withLinks(value.getLinks()).withTemplates(this.customizations.findTemplates(value)) : HalFormsDocument.empty().withEmbedded(embeddeds).withLinks(value.getLinks()).withTemplates(this.customizations.findTemplates(value));
            provider.findValueSerializer(HalFormsDocument.class, this.property).serialize(doc, gen, provider);
        }

        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Nullable
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(CollectionModel<?> resources) {
            return resources.getContent().size() == 1;
        }

        @Nullable
        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalFormsCollectionModelSerializer(this.customizations, property, this.embeddedMapper);
        }
    }

    static class HalFormsEntityModelSerializer
    extends ContainerSerializer<EntityModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -7912243216469101379L;
        private final HalFormsTemplateBuilder builder;
        private final BeanProperty property;

        HalFormsEntityModelSerializer(HalFormsTemplateBuilder builder, @Nullable BeanProperty property) {
            super(EntityModel.class, false);
            this.builder = builder;
            this.property = property;
        }

        HalFormsEntityModelSerializer(HalFormsTemplateBuilder builder) {
            this(builder, null);
        }

        public void serialize(EntityModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            HalFormsDocument<?> doc = HalFormsDocument.forEntity(value.getContent()).withLinks(value.getLinks()).withTemplates(this.builder.findTemplates(value));
            provider.findValueSerializer(HalFormsDocument.class, this.property).serialize(doc, gen, provider);
        }

        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Nullable
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(EntityModel<?> resource) {
            return false;
        }

        @Nullable
        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new HalFormsEntityModelSerializer(this.builder, property);
        }
    }

    static class HalFormsRepresentationModelSerializer
    extends ContainerSerializer<RepresentationModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -4583146321934407153L;
        private final HalFormsTemplateBuilder builder;
        private final BeanProperty property;

        HalFormsRepresentationModelSerializer(HalFormsTemplateBuilder builder, @Nullable BeanProperty property) {
            super(RepresentationModel.class, false);
            this.builder = builder;
            this.property = property;
        }

        HalFormsRepresentationModelSerializer(HalFormsTemplateBuilder customizations) {
            this(customizations, null);
        }

        public void serialize(RepresentationModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            HalFormsDocument<?> doc = HalFormsDocument.forRepresentationModel(value).withLinks(value.getLinks()).withTemplates(this.builder.findTemplates(value));
            provider.findValueSerializer(HalFormsDocument.class, this.property).serialize(doc, gen, provider);
        }

        @Nullable
        public JavaType getContentType() {
            return null;
        }

        @Nullable
        public JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(RepresentationModel<?> resource) {
            return false;
        }

        @Nullable
        protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
            return new HalFormsRepresentationModelSerializer(this.builder, property);
        }
    }
}

