/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;

public class HalConfiguration {
    private static final PathMatcher MATCHER = new AntPathMatcher();
    private final RenderSingleLinks renderSingleLinks;
    private final Map<String, RenderSingleLinks> singleLinksPerPattern;

    public HalConfiguration() {
        this.renderSingleLinks = RenderSingleLinks.AS_SINGLE;
        this.singleLinksPerPattern = new LinkedHashMap<String, RenderSingleLinks>();
    }

    public HalConfiguration withRenderSingleLinksFor(LinkRelation relation, RenderSingleLinks renderSingleLinks) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        Assert.notNull((Object)((Object)renderSingleLinks), (String)"RenderSingleLinks must not be null!");
        return this.withRenderSingleLinksFor(relation.value(), renderSingleLinks);
    }

    public HalConfiguration withRenderSingleLinksFor(String pattern, RenderSingleLinks renderSingleLinks) {
        LinkedHashMap<String, RenderSingleLinks> map = new LinkedHashMap<String, RenderSingleLinks>(this.singleLinksPerPattern);
        map.put(pattern, renderSingleLinks);
        return this.withSingleLinksPerPattern(map);
    }

    RenderSingleLinks getSingleLinkRenderModeFor(LinkRelation relation) {
        return this.singleLinksPerPattern.entrySet().stream().filter(entry -> MATCHER.match((String)entry.getKey(), relation.value())).map(Map.Entry::getValue).findFirst().orElse(this.renderSingleLinks);
    }

    @Generated
    private HalConfiguration(RenderSingleLinks renderSingleLinks, Map<String, RenderSingleLinks> singleLinksPerPattern) {
        this.renderSingleLinks = renderSingleLinks;
        this.singleLinksPerPattern = singleLinksPerPattern;
    }

    @Generated
    public HalConfiguration withRenderSingleLinks(RenderSingleLinks renderSingleLinks) {
        return this.renderSingleLinks == renderSingleLinks ? this : new HalConfiguration(renderSingleLinks, this.singleLinksPerPattern);
    }

    @Generated
    public RenderSingleLinks getRenderSingleLinks() {
        return this.renderSingleLinks;
    }

    @Generated
    private HalConfiguration withSingleLinksPerPattern(Map<String, RenderSingleLinks> singleLinksPerPattern) {
        return this.singleLinksPerPattern == singleLinksPerPattern ? this : new HalConfiguration(this.renderSingleLinks, singleLinksPerPattern);
    }

    public static enum RenderSingleLinks {
        AS_SINGLE,
        AS_ARRAY;

    }
}

