/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class TemplateVariable
implements Serializable {
    private static final long serialVersionUID = -2731446749851863774L;
    private final String name;
    private final VariableType type;
    private final String description;

    public TemplateVariable(String name, VariableType type) {
        this(name, type, "");
    }

    public TemplateVariable(String name, VariableType type, String description) {
        Assert.hasText((String)name, (String)"Variable name must not be null or empty!");
        Assert.notNull((Object)((Object)type), (String)"Variable type must not be null!");
        Assert.notNull((Object)description, (String)"Description must not be null!");
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public static TemplateVariable pathVariable(String variable) {
        return new TemplateVariable(variable, VariableType.PATH_VARIABLE);
    }

    public static TemplateVariable requestParameter(String parameter) {
        return new TemplateVariable(parameter, VariableType.REQUEST_PARAM);
    }

    public static TemplateVariable requestParameterContinued(String parameter) {
        return new TemplateVariable(parameter, VariableType.REQUEST_PARAM_CONTINUED);
    }

    public static TemplateVariable segment(String segment) {
        return new TemplateVariable(segment, VariableType.SEGMENT);
    }

    public static TemplateVariable fragment(String fragment) {
        return new TemplateVariable(fragment, VariableType.FRAGMENT);
    }

    public static TemplateVariable compositeParameter(String parameter) {
        return new TemplateVariable(parameter, VariableType.COMPOSITE_PARAM);
    }

    public boolean hasDescription() {
        return StringUtils.hasText((String)this.description);
    }

    boolean isRequired() {
        return !this.type.isOptional();
    }

    boolean isCombinable(TemplateVariable variable) {
        return this.type.canBeCombinedWith(variable.type);
    }

    boolean isEquivalent(TemplateVariable variable) {
        return this.name.equals(variable.name) && this.isCombinable(variable);
    }

    boolean isRequestParameterVariable() {
        return this.type.equals((Object)VariableType.REQUEST_PARAM) || this.type.equals((Object)VariableType.REQUEST_PARAM_CONTINUED);
    }

    boolean isFragment() {
        return this.type.equals((Object)VariableType.FRAGMENT);
    }

    public String toString() {
        String base = String.format("{%s%s}", this.type.toString(), this.name);
        return StringUtils.hasText((String)this.description) ? String.format("%s - %s", base, this.description) : base;
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateVariable that = (TemplateVariable)o;
        return Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.description});
    }

    public static enum VariableType {
        PATH_VARIABLE("", false),
        REQUEST_PARAM("?", true),
        REQUEST_PARAM_CONTINUED("&", true),
        SEGMENT("/", true),
        FRAGMENT("#", true),
        COMPOSITE_PARAM("*", true);

        private static final List<VariableType> COMBINABLE_TYPES;
        private final String key;
        private final boolean optional;

        private VariableType(String key, boolean optional) {
            this.key = key;
            this.optional = optional;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public boolean canBeCombinedWith(VariableType type) {
            return this.equals((Object)type) || COMBINABLE_TYPES.contains((Object)this) && COMBINABLE_TYPES.contains((Object)type);
        }

        public static VariableType from(String key) {
            return Arrays.stream(VariableType.values()).filter(type -> type.key.equals(key)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported variable type " + key + "!"));
        }

        public String toString() {
            return this.key;
        }

        static {
            COMBINABLE_TYPES = Arrays.asList(REQUEST_PARAM, REQUEST_PARAM_CONTINUED);
        }
    }
}

