/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AffordanceModel {
    private String name;
    private Link link;
    private HttpMethod httpMethod;
    private InputPayloadMetadata input;
    private List<QueryParameter> queryMethodParameters;
    private PayloadMetadata output;

    public AffordanceModel(String name, Link link, HttpMethod httpMethod, InputPayloadMetadata input, List<QueryParameter> queryMethodParameters, PayloadMetadata output) {
        this.name = name;
        this.link = link;
        this.httpMethod = httpMethod;
        this.input = input;
        this.queryMethodParameters = queryMethodParameters;
        this.output = output;
    }

    public String getURI() {
        return this.link.expand(new Object[0]).getHref();
    }

    public boolean hasHttpMethod(HttpMethod method) {
        Assert.notNull((Object)method, (String)"HttpMethod must not be null!");
        return this.httpMethod.equals((Object)method);
    }

    public boolean pointsToTargetOf(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return this.getURI().equals(link.expand(new Object[0]).getHref());
    }

    public String getName() {
        return this.name;
    }

    public Link getLink() {
        return this.link;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public InputPayloadMetadata getInput() {
        return this.input;
    }

    public List<QueryParameter> getQueryMethodParameters() {
        return this.queryMethodParameters;
    }

    public PayloadMetadata getOutput() {
        return this.output;
    }

    public <T> List<T> createProperties(BiFunction<InputPayloadMetadata, PropertyMetadata, T> creator) {
        return this.input.stream().map(it -> creator.apply(this.input, (PropertyMetadata)it)).collect(Collectors.toList());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffordanceModel that = (AffordanceModel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.link, that.link) && this.httpMethod == that.httpMethod && Objects.equals(this.input, that.input) && Objects.equals(this.queryMethodParameters, that.queryMethodParameters) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.link, this.httpMethod, this.input, this.queryMethodParameters, this.output);
    }

    public static interface InputPayloadMetadata
    extends PayloadMetadata {
        public static final InputPayloadMetadata NONE = InputPayloadMetadata.from(PayloadMetadata.NONE);

        public static InputPayloadMetadata from(PayloadMetadata metadata) {
            return InputPayloadMetadata.class.isInstance(metadata) ? (InputPayloadMetadata)InputPayloadMetadata.class.cast(metadata) : DelegatingInputPayloadMetadata.of(metadata);
        }

        @Deprecated
        default public <T extends PropertyMetadataConfigured<T> & Named> T applyTo(T target) {
            return (T)this.getPropertyMetadata(((Named)target).getName()).map(it -> (PropertyMetadataConfigured)target.apply((PropertyMetadata)it)).orElse(target);
        }

        public <T extends Named> T customize(T var1, Function<PropertyMetadata, T> var2);

        public List<String> getI18nCodes();

        public InputPayloadMetadata withMediaTypes(List<MediaType> var1);

        public List<MediaType> getMediaTypes();

        @Nullable
        default public MediaType getPrimaryMediaType() {
            List<MediaType> mediaTypes = this.getMediaTypes();
            return mediaTypes.isEmpty() ? null : mediaTypes.get(0);
        }
    }

    public static interface PayloadMetadata {
        public static final PayloadMetadata NONE = NoPayloadMetadata.INSTANCE;

        public Stream<PropertyMetadata> stream();

        @Deprecated
        default public Optional<PropertyMetadata> getPropertyMetadata(String name) {
            return this.stream().filter(it -> it.hasName(name)).findFirst();
        }

        @Nullable
        default public Class<?> getType() {
            return null;
        }
    }

    private static enum NoPayloadMetadata implements PayloadMetadata
    {
        INSTANCE;


        @Override
        public Stream<PropertyMetadata> stream() {
            return Stream.empty();
        }
    }

    public static interface Named {
        public String getName();
    }

    public static interface PropertyMetadataConfigured<T> {
        public T apply(PropertyMetadata var1);
    }

    public static interface PropertyMetadata
    extends Named {
        @Override
        public String getName();

        default public boolean hasName(String name) {
            Assert.hasText((String)name, (String)"Name must not be null or empty!");
            return this.getName().equals(name);
        }

        public boolean isRequired();

        public boolean isReadOnly();

        public Optional<String> getPattern();

        public ResolvableType getType();

        @Nullable
        default public Number getMin() {
            return null;
        }

        @Nullable
        default public Number getMax() {
            return null;
        }

        @Nullable
        default public Long getMinLength() {
            return null;
        }

        @Nullable
        default public Long getMaxLength() {
            return null;
        }

        @Nullable
        public String getInputType();
    }

    private static class DelegatingInputPayloadMetadata
    implements InputPayloadMetadata {
        private final PayloadMetadata metadata;
        private final List<MediaType> mediaTypes;

        public static DelegatingInputPayloadMetadata of(PayloadMetadata metadata) {
            return new DelegatingInputPayloadMetadata(metadata, Collections.emptyList());
        }

        private DelegatingInputPayloadMetadata(PayloadMetadata metadata, List<MediaType> mediaTypes) {
            this.metadata = metadata;
            this.mediaTypes = mediaTypes;
        }

        @Override
        public Stream<PropertyMetadata> stream() {
            return this.metadata.stream();
        }

        @Override
        public <T extends PropertyMetadataConfigured<T> & Named> T applyTo(T target) {
            return target;
        }

        @Override
        public <T extends Named> T customize(T target, Function<PropertyMetadata, T> customizer) {
            return target;
        }

        @Override
        public List<String> getI18nCodes() {
            return Collections.emptyList();
        }

        @Override
        public InputPayloadMetadata withMediaTypes(List<MediaType> mediaTypes) {
            return new DelegatingInputPayloadMetadata(this.metadata, mediaTypes);
        }

        @Override
        public List<MediaType> getMediaTypes() {
            return this.mediaTypes;
        }

        @Override
        @Nullable
        public Class<?> getType() {
            return this.metadata.getType();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelegatingInputPayloadMetadata that = (DelegatingInputPayloadMetadata)o;
            return Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.metadata);
        }

        public String toString() {
            return "AffordanceModel.DelegatingInputPayloadMetadata(metadata=" + String.valueOf(this.metadata) + ")";
        }
    }
}

