/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.VirtualBeanPropertyWriter;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.util.Assert;

public class ConfigurableHandlerInstantiator
extends HandlerInstantiator {
    private final Map<Class<?>, Object> instances = new HashMap();
    private final AutowireCapableBeanFactory beanFactory;

    protected ConfigurableHandlerInstantiator(AutowireCapableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null!");
        this.beanFactory = beanFactory;
    }

    protected void registerInstance(Object instance) {
        this.instances.put(instance.getClass(), instance);
    }

    protected <T> @Nullable T findInstance(Class<T> type) {
        return (T)this.instances.get(type);
    }

    protected <T> T findOrCreateInstance(Class<T> type) {
        T object = this.findInstance(type);
        return (T)(object != null ? object : this.beanFactory.getBeanProvider(type).getIfAvailable(() -> this.beanFactory.createBean(type)));
    }

    public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
        return (JsonDeserializer)this.findOrCreateInstance(deserClass);
    }

    public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
        return (KeyDeserializer)this.findOrCreateInstance(keyDeserClass);
    }

    public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
        return (JsonSerializer)this.findOrCreateInstance(serClass);
    }

    public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
        return (TypeResolverBuilder)this.findOrCreateInstance(builderClass);
    }

    public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
        return (TypeIdResolver)this.findOrCreateInstance(resolverClass);
    }

    public VirtualBeanPropertyWriter virtualPropertyWriterInstance(MapperConfig<?> config, Class<?> implClass) {
        return (VirtualBeanPropertyWriter)this.findOrCreateInstance(implClass);
    }
}

