/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.uber.UberAction;
import org.springframework.hateoas.mediatype.uber.UberAffordanceModel;
import org.springframework.http.HttpMethod;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@NullUnmarked
final class UberData {
    private final @Nullable String id;
    private final @Nullable String name;
    private final @Nullable String label;
    private final @Nullable List<LinkRelation> rel;
    private final @Nullable String url;
    private final @Nullable UberAction action;
    private final boolean transclude;
    private final @Nullable String model;
    private final @Nullable List<String> sending;
    private final @Nullable List<String> accepting;
    private final @Nullable Object value;
    private final @Nullable List<UberData> data;
    private static final HashSet<Class<?>> PRIMITIVE_TYPES = new HashSet<Class<String>>(Collections.singletonList(String.class));
    private static final HashSet<Class<?>> RESOURCE_TYPES = new HashSet<Class>(Arrays.asList(RepresentationModel.class, EntityModel.class, CollectionModel.class, PagedModel.class));

    @JsonCreator
    UberData(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="name") @Nullable String name, @JsonProperty(value="label") @Nullable String label, @JsonProperty(value="rel") @Nullable List<LinkRelation> rel, @JsonProperty(value="url") @Nullable String url, @JsonProperty(value="action") UberAction action, @JsonProperty(value="transclude") boolean transclude, @JsonProperty(value="model") @Nullable String model, @JsonProperty(value="sending") @Nullable List<String> sending, @JsonProperty(value="accepting") @Nullable List<String> accepting, @JsonProperty(value="value") @Nullable Object value, @JsonProperty(value="data") @Nullable List<UberData> data) {
        this.id = id;
        this.name = name;
        this.label = label;
        this.rel = rel;
        this.url = url;
        this.action = action;
        this.transclude = transclude;
        this.model = model;
        this.sending = sending;
        this.accepting = accepting;
        this.value = value;
        this.data = data;
    }

    UberData() {
        this(null, null, null, null, null, UberAction.READ, false, null, null, null, null, null);
    }

    @JsonProperty
    public @Nullable UberAction getAction() {
        return this.action == UberAction.READ ? null : this.action;
    }

    @JsonProperty
    public @Nullable Boolean isTemplated() {
        return Optional.ofNullable(this.url).map(s -> s.contains("{?") ? Boolean.valueOf(true) : null).orElse(null);
    }

    @JsonProperty
    public @Nullable Boolean isTransclude() {
        return this.transclude ? Boolean.valueOf(true) : null;
    }

    @JsonIgnore
    public List<Link> getLinks() {
        String url = this.url;
        if (url == null) {
            return Links.NONE.toList();
        }
        return Optional.ofNullable(this.rel).map(rels -> rels.stream().map(rel -> Link.of(url, rel)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private boolean hasUrl(@Nullable String url) {
        return ObjectUtils.nullSafeEquals((Object)this.url, (Object)url);
    }

    static List<UberData> extractLinksAndContent(RepresentationModel<?> resource) {
        List<UberData> data = UberData.extractLinks(resource);
        UberData.extractContent(resource).ifPresent(data::add);
        return data;
    }

    static List<UberData> extractLinksAndContent(EntityModel<?> resource) {
        List<UberData> data = UberData.extractLinks(resource);
        UberData.extractContent(resource.getContent()).ifPresent(data::add);
        return data;
    }

    static List<UberData> extractLinksAndContent(CollectionModel<?> resources) {
        List<UberData> data = UberData.extractLinks(resources);
        data.addAll(resources.getContent().stream().map(UberData::doExtractLinksAndContent).map(uberData -> new UberData().withData((List<UberData>)uberData)).collect(Collectors.toList()));
        return data;
    }

    static List<UberData> extractLinksAndContent(PagedModel<?> resources) {
        List<UberData> collectionOfResources = UberData.extractLinksAndContent(resources);
        if (resources.getMetadata() != null) {
            collectionOfResources.add(new UberData().withName("page").withData(Arrays.asList(new UberData().withName("number").withValue(resources.getMetadata().getNumber()), new UberData().withName("size").withValue(resources.getMetadata().getSize()), new UberData().withName("totalElements").withValue(resources.getMetadata().getTotalElements()), new UberData().withName("totalPages").withValue(resources.getMetadata().getTotalPages()))));
        }
        return collectionOfResources;
    }

    private static List<UberData> extractLinks(Links links) {
        return UberData.urlRelMap(links).entrySet().stream().map(entry -> new UberData().withUrl((String)entry.getKey()).withRel(((LinkAndRels)entry.getValue()).getRels())).collect(Collectors.toList());
    }

    private static List<UberData> extractLinks(RepresentationModel<?> resource) {
        ArrayList<UberData> data = new ArrayList<UberData>();
        List<UberData> links = UberData.extractLinks(resource.getLinks());
        List<UberData> affordanceBasedLinks = UberData.extractAffordances(resource.getLinks());
        if (affordanceBasedLinks.isEmpty()) {
            data.addAll(links);
        } else {
            data.addAll(UberData.mergeDeclaredLinksIntoAffordanceLinks(affordanceBasedLinks, links));
        }
        return data;
    }

    private static Optional<UberData> extractContent(@Nullable Object content) {
        return Optional.ofNullable(content).filter(it -> !RESOURCE_TYPES.contains(it.getClass())).map(it -> new UberData().withName(StringUtils.uncapitalize((String)it.getClass().getSimpleName())).withData(UberData.extractProperties(it)));
    }

    private static List<UberData> doExtractLinksAndContent(Object item) {
        if (item instanceof EntityModel) {
            return UberData.extractLinksAndContent((EntityModel)item);
        }
        if (item instanceof RepresentationModel) {
            return UberData.extractLinksAndContent((RepresentationModel)item);
        }
        return UberData.extractLinksAndContent(EntityModel.of(item));
    }

    private static Map<String, LinkAndRels> urlRelMap(Links links) {
        LinkedHashMap<String, LinkAndRels> urlRelMap = new LinkedHashMap<String, LinkAndRels>();
        links.forEach(link -> {
            LinkAndRels linkAndRels = urlRelMap.computeIfAbsent(link.getHref(), s -> new LinkAndRels());
            linkAndRels.setLink((Link)link);
            linkAndRels.getRels().add(link.getRel());
        });
        return urlRelMap;
    }

    private static List<UberData> extractAffordances(Links links) {
        return links.stream().flatMap(it -> it.getAffordances().stream()).map(it -> it.getAffordanceModel(MediaTypes.UBER_JSON)).map(UberAffordanceModel.class::cast).map(it -> {
            if (it.hasHttpMethod(HttpMethod.GET)) {
                Object suffix = it.getQueryProperties().stream().map(UberData::getName).collect(Collectors.joining(","));
                if (!it.getQueryMethodParameters().isEmpty()) {
                    suffix = "{?" + (String)suffix + "}";
                }
                return new UberData().withName(it.getName()).withRel(Collections.singletonList(LinkRelation.of(it.getName()))).withUrl(it.getLink().expand(new Object[0]).getHref() + (String)suffix).withAction(it.getAction());
            }
            return new UberData().withName(it.getName()).withRel(Collections.singletonList(LinkRelation.of(it.getName()))).withUrl(it.getLink().expand(new Object[0]).getHref()).withModel(it.getInputProperties().stream().map(UberData::getName).map(property -> property + "={" + property + "}").collect(Collectors.joining("&"))).withAction(it.getAction());
        }).collect(Collectors.toList());
    }

    private static List<UberData> mergeDeclaredLinksIntoAffordanceLinks(List<UberData> affordanceBasedLinks, List<UberData> links) {
        return affordanceBasedLinks.stream().flatMap(affordance -> links.stream().filter(data -> data.hasUrl(affordance.getUrl())).map(data -> {
            if (data.getAction() == affordance.getAction()) {
                ArrayList<LinkRelation> rels = new ArrayList<LinkRelation>(data.getRel());
                rels.addAll(affordance.getRel());
                return affordance.withName(((LinkRelation)rels.get(0)).value()).withRel(rels);
            }
            return affordance;
        })).collect(Collectors.toList());
    }

    private static List<UberData> extractProperties(Object obj) {
        if (PRIMITIVE_TYPES.contains(obj.getClass())) {
            return Collections.singletonList(new UberData().withValue(obj));
        }
        return PropertyUtils.extractPropertyValues(obj).entrySet().stream().map(entry -> new UberData().withName((String)entry.getKey()).withValue(entry.getValue())).collect(Collectors.toList());
    }

    UberData withId(@Nullable String id) {
        return this.id == id ? this : new UberData(id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withName(@Nullable String name) {
        return this.name == name ? this : new UberData(this.id, name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withLabel(@Nullable String label) {
        return this.label == label ? this : new UberData(this.id, this.name, label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withRel(@Nullable List<LinkRelation> rel) {
        return this.rel == rel ? this : new UberData(this.id, this.name, this.label, rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withUrl(@Nullable String url) {
        return this.url == url ? this : new UberData(this.id, this.name, this.label, this.rel, url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withAction(@Nullable UberAction action) {
        return this.action == action ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withTransclude(boolean transclude) {
        return this.transclude == transclude ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withModel(@Nullable String model) {
        return this.model == model ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, model, this.sending, this.accepting, this.value, this.data);
    }

    UberData withSending(@Nullable List<String> sending) {
        return this.sending == sending ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, sending, this.accepting, this.value, this.data);
    }

    UberData withAccepting(@Nullable List<String> accepting) {
        return this.accepting == accepting ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, accepting, this.value, this.data);
    }

    UberData withValue(@Nullable Object value) {
        return this.value == value ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, value, this.data);
    }

    UberData withData(@Nullable List<UberData> data) {
        return this.data == data ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, data);
    }

    @JsonProperty
    public @Nullable String getId() {
        return this.id;
    }

    @JsonProperty
    public @Nullable String getName() {
        return this.name;
    }

    @JsonProperty
    public @Nullable String getLabel() {
        return this.label;
    }

    @JsonProperty
    public @Nullable List<LinkRelation> getRel() {
        return this.rel;
    }

    @JsonProperty
    public @Nullable String getUrl() {
        return this.url;
    }

    @JsonProperty
    public @Nullable String getModel() {
        return this.model;
    }

    @JsonProperty
    public @Nullable List<String> getSending() {
        return this.sending;
    }

    @JsonProperty
    public @Nullable List<String> getAccepting() {
        return this.accepting;
    }

    @JsonProperty
    public @Nullable Object getValue() {
        return this.value;
    }

    @JsonProperty
    public @Nullable List<UberData> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UberData)) {
            return false;
        }
        UberData uberData = (UberData)o;
        return this.transclude == uberData.transclude && Objects.equals(this.id, uberData.id) && Objects.equals(this.name, uberData.name) && Objects.equals(this.label, uberData.label) && Objects.equals(this.rel, uberData.rel) && Objects.equals(this.url, uberData.url) && this.action == uberData.action && Objects.equals(this.model, uberData.model) && Objects.equals(this.sending, uberData.sending) && Objects.equals(this.accepting, uberData.accepting) && Objects.equals(this.value, uberData.value) && Objects.equals(this.data, uberData.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data});
    }

    public String toString() {
        return "UberData(id='" + this.id + "', name='" + this.name + "', label='" + this.label + "', rel=" + String.valueOf(this.rel) + ", url='" + this.url + "', action=" + String.valueOf((Object)this.action) + ", transclude=" + this.transclude + ", model='" + this.model + "', sending=" + String.valueOf(this.sending) + ", accepting=" + String.valueOf(this.accepting) + ", value=" + String.valueOf(this.value) + ", data=" + String.valueOf(this.data) + ")";
    }

    private static class LinkAndRels {
        private Link link;
        private List<LinkRelation> rels = new ArrayList<LinkRelation>();

        public Link getLink() {
            return this.link;
        }

        public List<LinkRelation> getRels() {
            return this.rels;
        }

        public void setLink(Link link) {
            this.link = link;
        }

        public void setRels(List<LinkRelation> rels) {
            this.rels = rels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LinkAndRels)) {
                return false;
            }
            LinkAndRels that = (LinkAndRels)o;
            return Objects.equals(this.link, that.link) && Objects.equals(this.rels, that.rels);
        }

        public int hashCode() {
            return Objects.hash(this.link, this.rels);
        }

        public String toString() {
            return "UberData.LinkAndRels(link=" + String.valueOf(this.link) + ", rels=" + String.valueOf(this.rels) + ")";
        }
    }
}

