/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationCustomizer;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationFactory;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalJacksonModule;
import org.springframework.hateoas.mediatype.hal.HalLinkDiscoverer;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.http.MediaType;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.json.JsonMapper;

@Configuration(proxyBeanMethods=false)
public class HalMediaTypeConfiguration
implements HypermediaMappingInformation {
    private final LinkRelationProvider relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final MediaTypeConfigurationFactory<HalConfiguration, ? extends MediaTypeConfigurationCustomizer<HalConfiguration>> configurationFactory;
    @Qualifier(value="messageResolver")
    private final MessageResolver resolver;
    private final AutowireCapableBeanFactory beanFactory;

    public HalMediaTypeConfiguration(LinkRelationProvider relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<MediaTypeConfigurationCustomizer<HalConfiguration>> customizers, MessageResolver resolver, AutowireCapableBeanFactory beanFactory) {
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.configurationFactory = new MediaTypeConfigurationFactory<HalConfiguration, MediaTypeConfigurationCustomizer<HalConfiguration>>(() -> (HalConfiguration)halConfiguration.getIfAvailable(HalConfiguration::new), customizers);
        this.resolver = resolver;
        this.beanFactory = beanFactory;
    }

    @Bean
    LinkDiscoverer halLinkDisocoverer() {
        return new HalLinkDiscoverer();
    }

    @Override
    public List<MediaType> getMediaTypes() {
        return this.configurationFactory.getConfiguration().getMediaTypes();
    }

    @Override
    public JsonMapper.Builder configureJsonMapper(JsonMapper.Builder builder) {
        HalConfiguration halConfiguration = this.configurationFactory.getConfiguration();
        JsonMapper.Builder prepared = (JsonMapper.Builder)((JsonMapper.Builder)builder.addModule((JacksonModule)new HalJacksonModule())).handlerInstantiator((HandlerInstantiator)new HalJacksonModule.HalHandlerInstantiator(this.relProvider, (CurieProvider)this.curieProvider.getIfAvailable(() -> CurieProvider.NONE), this.resolver, halConfiguration, this.beanFactory));
        return halConfiguration.customize(prepared);
    }
}

