/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsAffordanceModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsPropertyFactory;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class HalFormsTemplateBuilder {
    private final MessageResolver resolver;
    private final HalFormsPropertyFactory factory;
    private final HalFormsConfiguration configuration;

    public HalFormsTemplateBuilder(HalFormsConfiguration configuration, MessageResolver resolver) {
        this.resolver = resolver;
        this.factory = new HalFormsPropertyFactory(configuration, resolver);
        this.configuration = configuration;
    }

    public Map<String, HalFormsTemplate> findTemplates(RepresentationModel<?> resource) {
        HashMap<String, HalFormsTemplate> templates = new HashMap<String, HalFormsTemplate>();
        Link selfLink = resource.getLink(IanaLinkRelations.SELF).orElse(null);
        resource.getLinks().stream().flatMap(it -> it.getAffordances().stream()).map(it -> it.getAffordanceModel(MediaTypes.HAL_FORMS_JSON)).peek(it -> Assert.notNull((Object)it, (String)"No HAL Forms affordance model found but expected!")).map(HalFormsAffordanceModel.class::cast).filter(it -> !it.hasHttpMethod(HttpMethod.GET)).forEach(it -> {
            HalFormsTemplate template = HalFormsTemplate.forMethod(it.getHttpMethod()).withProperties(this.factory.createProperties((HalFormsAffordanceModel)it)).withContentType(it.getInput().getPrimaryMediaType());
            String target = it.getLink().expand(new Object[0]).getHref();
            if (selfLink == null || !target.equals(selfLink.getHref())) {
                template = template.withTarget(target);
            }
            template = this.applyTo(template, TemplateTitle.of(it, templates.isEmpty()));
            String name = templates.isEmpty() && this.configuration.isDefaultSingleTemplate() ? "default" : it.getName();
            templates.put(name, template);
        });
        return templates;
    }

    private HalFormsTemplate applyTo(HalFormsTemplate template, TemplateTitle templateTitle) {
        return Optional.ofNullable(this.resolver.resolve(templateTitle)).filter(StringUtils::hasText).map(template::withTitle).orElse(template);
    }

    private static class TemplateTitle
    implements MessageSourceResolvable {
        private static final String TEMPLATE_TEMPLATE = "_templates.%s.title";
        private final HalFormsAffordanceModel affordance;
        private final boolean soleTemplate;

        private TemplateTitle(HalFormsAffordanceModel affordance, boolean soleTemplate) {
            this.affordance = affordance;
            this.soleTemplate = soleTemplate;
        }

        public static TemplateTitle of(HalFormsAffordanceModel affordance, boolean soleTemplate) {
            return new TemplateTitle(affordance, soleTemplate);
        }

        public String @NonNull [] getCodes() {
            Stream<String> seed = Stream.concat(Stream.of(this.affordance.getName()), this.soleTemplate ? Stream.of("default") : Stream.empty());
            return (String[])seed.flatMap(it -> TemplateTitle.getCodesFor(it, this.affordance.getInput())).toArray(String[]::new);
        }

        private static Stream<String> getCodesFor(String name, AffordanceModel.InputPayloadMetadata type) {
            String global = String.format(TEMPLATE_TEMPLATE, name);
            Stream<String> inputBased = type.getI18nCodes().stream().map(it -> String.format("%s.%s", it, global));
            return Stream.concat(inputBased, Stream.of(global));
        }

        public @Nullable String getDefaultMessage() {
            return "";
        }
    }
}

