/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.inbound;

import com.rabbitmq.client.Channel;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.core.AttributeAccessor;
import org.springframework.integration.StaticMessageHeaderAccessor;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.AmqpMessageHeaderErrorMessageStrategy;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.amqp.support.EndpointUtils;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.support.RetrySynchronizationManager;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AmqpInboundGateway
extends MessagingGatewaySupport {
    private static final ThreadLocal<AttributeAccessor> attributesHolder = new ThreadLocal();
    private final AbstractMessageListenerContainer messageListenerContainer;
    private final AmqpTemplate amqpTemplate;
    private final boolean amqpTemplateExplicitlySet;
    private volatile MessageConverter amqpMessageConverter = new SimpleMessageConverter();
    private volatile AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.inboundMapper();
    private Address defaultReplyTo;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;

    public AmqpInboundGateway(AbstractMessageListenerContainer listenerContainer) {
        this(listenerContainer, (AmqpTemplate)new RabbitTemplate(listenerContainer.getConnectionFactory()), false);
    }

    public AmqpInboundGateway(AbstractMessageListenerContainer listenerContainer, AmqpTemplate amqpTemplate) {
        this(listenerContainer, amqpTemplate, true);
    }

    private AmqpInboundGateway(AbstractMessageListenerContainer listenerContainer, AmqpTemplate amqpTemplate, boolean amqpTemplateExplicitlySet) {
        Assert.notNull((Object)listenerContainer, (String)"listenerContainer must not be null");
        Assert.notNull((Object)amqpTemplate, (String)"'amqpTemplate' must not be null");
        Assert.isNull((Object)listenerContainer.getMessageListener(), (String)"The listenerContainer provided to an AMQP inbound Gateway must not have a MessageListener configured since the adapter needs to configure its own listener implementation.");
        this.messageListenerContainer = listenerContainer;
        this.messageListenerContainer.setAutoStartup(false);
        this.amqpTemplate = amqpTemplate;
        this.amqpTemplateExplicitlySet = amqpTemplateExplicitlySet;
        this.setErrorMessageStrategy(new AmqpMessageHeaderErrorMessageStrategy());
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"MessageConverter must not be null");
        this.amqpMessageConverter = messageConverter;
        if (!this.amqpTemplateExplicitlySet) {
            ((RabbitTemplate)this.amqpTemplate).setMessageConverter(messageConverter);
        }
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setDefaultReplyTo(String defaultReplyTo) {
        this.defaultReplyTo = new Address(defaultReplyTo);
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public String getComponentType() {
        return "amqp:inbound-gateway";
    }

    protected void onInit() {
        if (this.retryTemplate != null) {
            Assert.state((this.getErrorChannel() == null ? 1 : 0) != 0, (String)"Cannot have an 'errorChannel' property when a 'RetryTemplate' is provided; use an 'ErrorMessageSendingRecoverer' in the 'recoveryCallback' property to send an error message when retries are exhausted");
        }
        Listener messageListener = new Listener();
        this.messageListenerContainer.setMessageListener((MessageListener)messageListener);
        this.messageListenerContainer.afterPropertiesSet();
        if (!this.amqpTemplateExplicitlySet) {
            ((RabbitTemplate)this.amqpTemplate).afterPropertiesSet();
        }
        super.onInit();
        if (this.retryTemplate != null && this.getErrorChannel() != null) {
            this.logger.warn((Object)"Usually, when using a RetryTemplate you should use an ErrorMessageSendingRecoverer and not provide an errorChannel. Using an errorChannel could defeat retry and will receive an error message for each delivery attempt.");
        }
    }

    protected void doStart() {
        super.doStart();
        this.messageListenerContainer.start();
    }

    protected void doStop() {
        super.doStop();
        this.messageListenerContainer.stop();
    }

    private void setAttributesIfNecessary(org.springframework.amqp.core.Message amqpMessage, Message<?> message) {
        boolean needAttributes;
        boolean needHolder = this.getErrorChannel() != null && this.retryTemplate == null;
        boolean bl = needAttributes = needHolder || this.retryTemplate != null;
        if (needHolder) {
            attributesHolder.set(ErrorMessageUtils.getAttributeAccessor(null, null));
        }
        if (needAttributes) {
            RetryContext attributes;
            Object object = attributes = this.retryTemplate != null ? RetrySynchronizationManager.getContext() : attributesHolder.get();
            if (attributes != null) {
                attributes.setAttribute("inputMessage", message);
                attributes.setAttribute("amqp_raw_message", (Object)amqpMessage);
            }
        }
    }

    protected AttributeAccessor getErrorMessageAttributes(Message<?> message) {
        AttributeAccessor attributes = attributesHolder.get();
        if (attributes == null) {
            return super.getErrorMessageAttributes(message);
        }
        return attributes;
    }

    protected class Listener
    implements ChannelAwareMessageListener {
        protected Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onMessage(org.springframework.amqp.core.Message message, Channel channel) throws Exception {
            if (AmqpInboundGateway.this.retryTemplate == null) {
                try {
                    Message<Object> converted = this.convert(message, channel);
                    if (converted == null) return;
                    this.process(message, converted);
                    return;
                }
                finally {
                    attributesHolder.remove();
                }
            } else {
                Message<Object> converted = this.convert(message, channel);
                if (converted == null) return;
                AmqpInboundGateway.this.retryTemplate.execute(context -> {
                    StaticMessageHeaderAccessor.getDeliveryAttempt((Message)converted).incrementAndGet();
                    this.process(message, converted);
                    return null;
                }, AmqpInboundGateway.this.recoveryCallback);
            }
        }

        private Message<Object> convert(org.springframework.amqp.core.Message message, Channel channel) {
            Map headers;
            Object payload;
            boolean isManualAck = AmqpInboundGateway.this.messageListenerContainer.getAcknowledgeMode() == AcknowledgeMode.MANUAL;
            try {
                payload = AmqpInboundGateway.this.amqpMessageConverter.fromMessage(message);
                headers = AmqpInboundGateway.this.headerMapper.toHeadersFromRequest(message.getMessageProperties());
                if (isManualAck) {
                    headers.put("amqp_deliveryTag", message.getMessageProperties().getDeliveryTag());
                    headers.put("amqp_channel", channel);
                }
                if (AmqpInboundGateway.this.retryTemplate != null) {
                    headers.put("deliveryAttempt", new AtomicInteger());
                }
            }
            catch (RuntimeException e) {
                MessageChannel errorChannel = AmqpInboundGateway.this.getErrorChannel();
                if (errorChannel == null) {
                    throw e;
                }
                AmqpInboundGateway.this.setAttributesIfNecessary(message, null);
                AmqpInboundGateway.this.messagingTemplate.send((Object)errorChannel, (Message)AmqpInboundGateway.this.buildErrorMessage(null, (Throwable)EndpointUtils.errorMessagePayload(message, channel, isManualAck, e)));
                return null;
            }
            return AmqpInboundGateway.this.getMessageBuilderFactory().withPayload(payload).copyHeaders(headers).build();
        }

        private void process(org.springframework.amqp.core.Message message, Message<Object> messagingMessage) {
            AmqpInboundGateway.this.setAttributesIfNecessary(message, messagingMessage);
            Message reply = AmqpInboundGateway.this.sendAndReceiveMessage(messagingMessage);
            if (reply != null) {
                String replyToProperty = message.getMessageProperties().getReplyTo();
                Address replyTo = replyToProperty != null ? new Address(replyToProperty) : AmqpInboundGateway.this.defaultReplyTo;
                MessagePostProcessor messagePostProcessor = message1 -> {
                    MessageProperties messageProperties = message1.getMessageProperties();
                    String contentEncoding = messageProperties.getContentEncoding();
                    long contentLength = messageProperties.getContentLength();
                    String contentType = messageProperties.getContentType();
                    AmqpInboundGateway.this.headerMapper.fromHeadersToReply(reply.getHeaders(), messageProperties);
                    messageProperties.setReplyTo(null);
                    if (StringUtils.hasText((String)contentEncoding)) {
                        messageProperties.setContentEncoding(contentEncoding);
                    }
                    messageProperties.setContentLength(contentLength);
                    if (contentType != null) {
                        messageProperties.setContentType(contentType);
                    }
                    return message1;
                };
                if (replyTo != null) {
                    AmqpInboundGateway.this.amqpTemplate.convertAndSend(replyTo.getExchangeName(), replyTo.getRoutingKey(), reply.getPayload(), messagePostProcessor);
                } else {
                    if (!AmqpInboundGateway.this.amqpTemplateExplicitlySet) {
                        throw new IllegalStateException("There is no 'replyTo' message property and the `defaultReplyTo` hasn't been configured.");
                    }
                    AmqpInboundGateway.this.amqpTemplate.convertAndSend(reply.getPayload(), messagePostProcessor);
                }
            }
        }
    }
}

