/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.channel;

import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.integration.amqp.channel.AbstractSubscribableAmqpChannel;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.RoundRobinLoadBalancingStrategy;
import org.springframework.integration.dispatcher.UnicastingDispatcher;

public class PointToPointSubscribableAmqpChannel
extends AbstractSubscribableAmqpChannel {
    private volatile Queue queue;

    public PointToPointSubscribableAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate) {
        super(channelName, container, amqpTemplate);
    }

    public PointToPointSubscribableAmqpChannel(String channelName, AbstractMessageListenerContainer container, AmqpTemplate amqpTemplate, AmqpHeaderMapper outboundMapper, AmqpHeaderMapper inboundMapper) {
        super(channelName, container, amqpTemplate, outboundMapper, inboundMapper);
    }

    public void setQueueName(String queueName) {
        this.queue = new Queue(queueName);
    }

    @Override
    protected String obtainQueueName(String channelName) {
        if (this.queue == null) {
            this.queue = new Queue(channelName);
        }
        return this.queue.getName();
    }

    @Override
    protected AbstractDispatcher createDispatcher() {
        UnicastingDispatcher unicastingDispatcher = new UnicastingDispatcher();
        unicastingDispatcher.setLoadBalancingStrategy((LoadBalancingStrategy)new RoundRobinLoadBalancingStrategy());
        return unicastingDispatcher;
    }

    @Override
    protected String getRoutingKey() {
        return this.queue != null ? this.queue.getName() : super.getRoutingKey();
    }

    @Override
    protected void doDeclares() {
        AmqpAdmin admin = this.getAdmin();
        if (admin != null && this.queue != null && admin.getQueueProperties(this.queue.getName()) == null) {
            admin.declareQueue(this.queue);
        }
    }
}

