/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.aws.outbound.SqsMessageHandler;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SqsOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinition queue;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SqsMessageHandler.class);
        String template = element.getAttribute("queue-messaging-template");
        boolean hasTemplate = StringUtils.hasText((String)template);
        String sqs = element.getAttribute("sqs");
        boolean hasSqs = StringUtils.hasText((String)sqs);
        String resourceIdResolver = element.getAttribute("resource-id-resolver");
        boolean hasResourceIdResolver = StringUtils.hasText((String)resourceIdResolver);
        if (hasTemplate && (hasSqs || hasResourceIdResolver)) {
            parserContext.getReaderContext().error("queue-messaging-template should not be defined in conjunction with sqs or resource-id-resolver", (Object)element);
        }
        if (!hasTemplate && !hasSqs) {
            parserContext.getReaderContext().error("One of queue-messaging-template or sqs must be defined.", (Object)element);
        }
        if (hasSqs) {
            builder.addConstructorArgReference(sqs);
        }
        if (hasResourceIdResolver) {
            builder.addConstructorArgReference(resourceIdResolver);
        }
        if (hasTemplate) {
            builder.addConstructorArgReference(template);
        }
        if ((queue = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"queue", (String)"queue-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            builder.addPropertyValue("queueExpression", (Object)queue);
        }
        return builder.getBeanDefinition();
    }
}

