/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.AmazonClientException;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.event.ProgressListener;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SetObjectAclRequest;
import com.amazonaws.services.s3.transfer.ObjectMetadataProvider;
import com.amazonaws.services.s3.transfer.PersistableTransfer;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListener;
import com.amazonaws.services.s3.transfer.internal.S3ProgressListenerChain;
import com.amazonaws.util.Md5Utils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class S3MessageHandler
extends AbstractReplyProducingMessageHandler {
    private final TransferManager transferManager;
    private final boolean produceReply;
    private final Expression bucketExpression;
    private EvaluationContext evaluationContext;
    private Expression keyExpression;
    private Expression objectAclExpression;
    private Expression destinationBucketExpression;
    private Expression destinationKeyExpression;
    private Expression commandExpression = new ValueExpression((Object)Command.UPLOAD);
    private S3ProgressListener s3ProgressListener;
    private UploadMetadataProvider uploadMetadataProvider;
    private ResourceIdResolver resourceIdResolver;

    public S3MessageHandler(AmazonS3 amazonS3, String bucket) {
        this(amazonS3, bucket, false);
    }

    public S3MessageHandler(AmazonS3 amazonS3, Expression bucketExpression) {
        this(amazonS3, bucketExpression, false);
    }

    public S3MessageHandler(AmazonS3 amazonS3, String bucket, boolean produceReply) {
        this(new TransferManager(amazonS3), bucket, produceReply);
        Assert.notNull((Object)amazonS3, (String)"'amazonS3' must not be null");
    }

    public S3MessageHandler(AmazonS3 amazonS3, Expression bucketExpression, boolean produceReply) {
        this(new TransferManager(amazonS3), bucketExpression, produceReply);
        Assert.notNull((Object)amazonS3, (String)"'amazonS3' must not be null");
    }

    public S3MessageHandler(TransferManager transferManager, String bucket) {
        this(transferManager, bucket, false);
    }

    public S3MessageHandler(TransferManager transferManager, Expression bucketExpression) {
        this(transferManager, bucketExpression, false);
    }

    public S3MessageHandler(TransferManager transferManager, String bucket, boolean produceReply) {
        this(transferManager, (Expression)new LiteralExpression(bucket), produceReply);
        Assert.notNull((Object)bucket, (String)"'bucket' must not be null");
    }

    public S3MessageHandler(TransferManager transferManager, Expression bucketExpression, boolean produceReply) {
        Assert.notNull((Object)transferManager, (String)"'transferManager' must not be null");
        Assert.notNull((Object)bucketExpression, (String)"'bucketExpression' must not be null");
        this.transferManager = transferManager;
        this.bucketExpression = bucketExpression;
        this.produceReply = produceReply;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    public void setObjectAclExpression(Expression objectAclExpression) {
        this.objectAclExpression = objectAclExpression;
    }

    public void setCommand(Command command) {
        Assert.notNull((Object)((Object)command), (String)"'command' must not be null");
        this.setCommandExpression((Expression)new ValueExpression((Object)command));
    }

    public void setCommandExpression(Expression commandExpression) {
        Assert.notNull((Object)commandExpression, (String)"'commandExpression' must not be null");
        this.commandExpression = commandExpression;
    }

    public void setDestinationBucketExpression(Expression destinationBucketExpression) {
        this.destinationBucketExpression = destinationBucketExpression;
    }

    public void setDestinationKeyExpression(Expression destinationKeyExpression) {
        this.destinationKeyExpression = destinationKeyExpression;
    }

    public void setProgressListener(S3ProgressListener s3ProgressListener) {
        this.s3ProgressListener = s3ProgressListener;
    }

    public void setUploadMetadataProvider(UploadMetadataProvider uploadMetadataProvider) {
        this.uploadMetadataProvider = uploadMetadataProvider;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    protected void doInit() {
        Assert.notNull((Object)this.bucketExpression, (String)"The 'bucketExpression' must not be null");
        super.doInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Command command = (Command)((Object)this.commandExpression.getValue(this.evaluationContext, requestMessage, Command.class));
        Assert.state((command != null ? 1 : 0) != 0, (String)("'commandExpression' [" + this.commandExpression.getExpressionString() + "] cannot evaluate to null."));
        Transfer transfer = null;
        switch (command) {
            case UPLOAD: {
                transfer = this.upload(requestMessage);
                break;
            }
            case DOWNLOAD: {
                transfer = this.download(requestMessage);
                break;
            }
            case COPY: {
                transfer = this.copy(requestMessage);
            }
        }
        if (this.produceReply) {
            return transfer;
        }
        try {
            AmazonClientException amazonClientException = transfer.waitForException();
            if (amazonClientException != null) {
                throw amazonClientException;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private Transfer upload(Message<?> requestMessage) {
        PutObjectRequest putObjectRequest;
        String key;
        String bucketName;
        block21: {
            Object payload = requestMessage.getPayload();
            bucketName = this.obtainBucket(requestMessage);
            key = null;
            if (this.keyExpression != null) {
                key = (String)this.keyExpression.getValue(this.evaluationContext, requestMessage, String.class);
            }
            if (payload instanceof File && ((File)payload).isDirectory()) {
                File fileToUpload = (File)payload;
                if (key == null) {
                    key = fileToUpload.getName();
                }
                return this.transferManager.uploadDirectory(bucketName, key, fileToUpload, true, (ObjectMetadataProvider)new MessageHeadersObjectMetadataProvider(requestMessage.getHeaders()));
            }
            ObjectMetadata metadata = new ObjectMetadata();
            if (this.uploadMetadataProvider != null) {
                this.uploadMetadataProvider.populateMetadata(metadata, requestMessage);
            }
            putObjectRequest = null;
            try {
                String contentMd5;
                if (payload instanceof InputStream) {
                    InputStream inputStream = (InputStream)payload;
                    if (metadata.getContentMD5() == null) {
                        Assert.state((boolean)inputStream.markSupported(), (String)"For an upload InputStream with no MD5 digest metadata, the markSupported() method must evaluate to true. ");
                        contentMd5 = Md5Utils.md5AsBase64((InputStream)inputStream);
                        metadata.setContentMD5(contentMd5);
                        inputStream.reset();
                    }
                    putObjectRequest = new PutObjectRequest(bucketName, key, inputStream, metadata);
                    break block21;
                }
                if (payload instanceof File) {
                    File fileToUpload = (File)payload;
                    if (key == null) {
                        key = fileToUpload.getName();
                    }
                    if (metadata.getContentMD5() == null) {
                        contentMd5 = Md5Utils.md5AsBase64((File)fileToUpload);
                        metadata.setContentMD5(contentMd5);
                    }
                    if (metadata.getContentLength() == 0L) {
                        metadata.setContentLength(fileToUpload.length());
                    }
                    if (metadata.getContentType() == null) {
                        metadata.setContentType(Mimetypes.getInstance().getMimetype(fileToUpload));
                    }
                    putObjectRequest = new PutObjectRequest(bucketName, key, fileToUpload).withMetadata(metadata);
                    break block21;
                }
                if (payload instanceof byte[]) {
                    byte[] payloadBytes = (byte[])payload;
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(payloadBytes);
                    if (metadata.getContentMD5() == null) {
                        String contentMd52 = Md5Utils.md5AsBase64((InputStream)inputStream);
                        metadata.setContentMD5(contentMd52);
                        ((InputStream)inputStream).reset();
                    }
                    if (metadata.getContentLength() == 0L) {
                        metadata.setContentLength((long)payloadBytes.length);
                    }
                    putObjectRequest = new PutObjectRequest(bucketName, key, (InputStream)inputStream, metadata);
                    break block21;
                }
                throw new IllegalArgumentException("Unsupported payload type: [" + payload.getClass() + "]. The only supported payloads for the upload request are " + "java.io.File, java.io.InputStream, byte[] and PutObjectRequest.");
            }
            catch (IOException e) {
                throw new MessageHandlingException(requestMessage, (Throwable)e);
            }
        }
        Assert.state((key != null ? 1 : 0) != 0, (String)("The 'keyExpression' must not be null for non-File payloads and can't evaluate to null. Root object is: " + requestMessage));
        if (key == null) {
            if (this.keyExpression != null) {
                throw new IllegalStateException("The 'keyExpression' [" + this.keyExpression.getExpressionString() + "] must not evaluate to null. Root object is: " + requestMessage);
            }
            throw new IllegalStateException("Specify a 'keyExpression' for non-java.io.File payloads");
        }
        S3ProgressListener progressListener = this.s3ProgressListener;
        if (this.objectAclExpression != null) {
            Object acl = this.objectAclExpression.getValue(this.evaluationContext, requestMessage);
            Assert.state((acl instanceof AccessControlList || acl instanceof CannedAccessControlList ? 1 : 0) != 0, (String)("The 'objectAclExpression' [" + this.objectAclExpression.getExpressionString() + "] must evaluate to com.amazonaws.services.s3.model.AccessControlList " + "or must evaluate to com.amazonaws.services.s3.model.CannedAccessControlList. " + "Gotten: [" + acl + "]"));
            SetObjectAclRequest aclRequest = acl instanceof AccessControlList ? new SetObjectAclRequest(bucketName, key, (AccessControlList)acl) : new SetObjectAclRequest(bucketName, key, (CannedAccessControlList)acl);
            final SetObjectAclRequest theAclRequest = aclRequest;
            progressListener = new S3ProgressListener(){

                public void onPersistableTransfer(PersistableTransfer persistableTransfer) {
                }

                public void progressChanged(ProgressEvent progressEvent) {
                    if (ProgressEventType.TRANSFER_COMPLETED_EVENT.equals((Object)progressEvent.getEventType())) {
                        S3MessageHandler.this.transferManager.getAmazonS3Client().setObjectAcl(theAclRequest);
                    }
                }
            };
            if (this.s3ProgressListener != null) {
                progressListener = new S3ProgressListenerChain(new ProgressListener[]{this.s3ProgressListener, progressListener});
            }
        }
        if (progressListener != null) {
            return this.transferManager.upload(putObjectRequest, progressListener);
        }
        return this.transferManager.upload(putObjectRequest);
    }

    private Transfer download(Message<?> requestMessage) {
        Object payload = requestMessage.getPayload();
        Assert.state((boolean)(payload instanceof File), (String)("For the 'DOWNLOAD' operation the 'payload' must be of 'java.io.File' type, but gotten: [" + payload.getClass() + ']'));
        File targetFile = (File)payload;
        String bucket = this.obtainBucket(requestMessage);
        String key = null;
        key = this.keyExpression != null ? (String)this.keyExpression.getValue(this.evaluationContext, requestMessage, String.class) : targetFile.getName();
        Assert.state((key != null ? 1 : 0) != 0, (String)("The 'keyExpression' must not be null for non-File payloads and can't evaluate to null. Root object is: " + requestMessage));
        if (targetFile.isDirectory()) {
            return this.transferManager.downloadDirectory(bucket, key, targetFile);
        }
        if (this.s3ProgressListener != null) {
            return this.transferManager.download(new GetObjectRequest(bucket, key), targetFile, this.s3ProgressListener);
        }
        return this.transferManager.download(bucket, key, targetFile);
    }

    private Transfer copy(Message<?> requestMessage) {
        String sourceBucketName = this.obtainBucket(requestMessage);
        String sourceKey = null;
        if (this.keyExpression != null) {
            sourceKey = (String)this.keyExpression.getValue(this.evaluationContext, requestMessage, String.class);
        }
        Assert.state((sourceKey != null ? 1 : 0) != 0, (String)("The 'keyExpression' must not be null for 'copy' operation and can't evaluate to null. Root object is: " + requestMessage));
        String destinationBucketName = null;
        if (this.destinationBucketExpression != null) {
            destinationBucketName = (String)this.destinationBucketExpression.getValue(this.evaluationContext, requestMessage, String.class);
        }
        if (this.resourceIdResolver != null) {
            destinationBucketName = this.resourceIdResolver.resolveToPhysicalResourceId(destinationBucketName);
        }
        Assert.state((destinationBucketName != null ? 1 : 0) != 0, (String)("The 'destinationBucketExpression' must not be null for 'copy' operation and can't evaluate to null. Root object is: " + requestMessage));
        String destinationKey = null;
        if (this.destinationKeyExpression != null) {
            destinationKey = (String)this.destinationKeyExpression.getValue(this.evaluationContext, requestMessage, String.class);
        }
        Assert.state((destinationKey != null ? 1 : 0) != 0, (String)("The 'destinationKeyExpression' must not be null for 'copy' operation and can't evaluate to null. Root object is: " + requestMessage));
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey);
        return this.transferManager.copy(copyObjectRequest);
    }

    private String obtainBucket(Message<?> requestMessage) {
        String bucketName = this.bucketExpression instanceof LiteralExpression ? (String)this.bucketExpression.getValue() : (String)this.bucketExpression.getValue(this.evaluationContext, requestMessage, String.class);
        Assert.state((bucketName != null ? 1 : 0) != 0, (String)("The 'bucketExpression' [" + this.bucketExpression.getExpressionString() + "] must not evaluate to null. Root object is: " + requestMessage));
        if (this.resourceIdResolver != null) {
            bucketName = this.resourceIdResolver.resolveToPhysicalResourceId(bucketName);
        }
        return bucketName;
    }

    private class MessageHeadersObjectMetadataProvider
    implements ObjectMetadataProvider {
        private final MessageHeaders messageHeaders;

        MessageHeadersObjectMetadataProvider(MessageHeaders messageHeaders) {
            this.messageHeaders = messageHeaders;
        }

        public void provideObjectMetadata(File file, ObjectMetadata metadata) {
            if (S3MessageHandler.this.uploadMetadataProvider != null) {
                S3MessageHandler.this.uploadMetadataProvider.populateMetadata(metadata, MessageBuilder.createMessage((Object)file, (MessageHeaders)this.messageHeaders));
            }
            if (metadata.getContentMD5() == null) {
                try {
                    String contentMd5 = Md5Utils.md5AsBase64((File)file);
                    metadata.setContentMD5(contentMd5);
                }
                catch (Exception e) {
                    throw new AmazonClientException((Throwable)e);
                }
            }
        }
    }

    public static interface UploadMetadataProvider {
        public void populateMetadata(ObjectMetadata var1, Message<?> var2);
    }

    public static enum Command {
        UPLOAD,
        DOWNLOAD,
        COPY;

    }
}

