/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import com.amazonaws.services.sqs.AmazonSQS;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.core.QueueMessagingTemplate;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SqsMessageHandler
extends AbstractMessageHandler {
    private final QueueMessagingTemplate template;
    private Expression queueExpression;
    private EvaluationContext evaluationContext;

    public SqsMessageHandler(AmazonSQS amazonSqs) {
        this(amazonSqs, null);
    }

    public SqsMessageHandler(AmazonSQS amazonSqs, ResourceIdResolver resourceIdResolver) {
        this(new QueueMessagingTemplate(amazonSqs, resourceIdResolver));
    }

    public SqsMessageHandler(QueueMessagingTemplate template) {
        Assert.notNull((Object)template, (String)"template must not be null.");
        this.template = template;
    }

    public void setQueue(String queue) {
        Assert.hasText((String)queue, (String)"'queue' must not be empty");
        this.queueExpression = new LiteralExpression(queue);
    }

    public void setQueueExpression(Expression queueExpression) {
        Assert.notNull((Object)queueExpression, (String)"'queueExpression' must not be null");
        this.queueExpression = queueExpression;
    }

    protected void onInit() throws Exception {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        String queue = (String)message.getHeaders().get((Object)"aws_queue", String.class);
        if (!StringUtils.hasText((String)queue) && this.queueExpression != null) {
            queue = (String)this.queueExpression.getValue(this.evaluationContext, message, String.class);
        }
        Assert.state((queue != null ? 1 : 0) != 0, (String)"'queue' must not be null for sending an SQS message. Consider configuring this handler with a 'queue'( or 'queueExpression') or supply an 'aws_queue' message header");
        this.template.send(queue, message);
    }
}

