/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.support;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class S3Session
implements Session<S3ObjectSummary> {
    private final AmazonS3 amazonS3;
    private final ResourceIdResolver resourceIdResolver;

    public S3Session(AmazonS3 amazonS3) {
        this(amazonS3, null);
    }

    public S3Session(AmazonS3 amazonS3, ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
        Assert.notNull((Object)amazonS3, (String)"'amazonS3' must not be null.");
        this.amazonS3 = amazonS3;
    }

    public S3ObjectSummary[] list(String path) throws IOException {
        ObjectListing objectListing;
        Assert.hasText((String)path, (String)"'path' must not be empty String.");
        String[] bucketPrefix = path.split("/");
        Assert.state((bucketPrefix.length > 0 && bucketPrefix[0].length() >= 3 ? 1 : 0) != 0, (String)"S3 bucket name must be at least 3 characters long.");
        String bucket = this.resolveBucket(bucketPrefix[0]);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucket);
        if (bucketPrefix.length > 1) {
            listObjectsRequest.setPrefix(bucketPrefix[1]);
        }
        ArrayList objectSummaries = new ArrayList();
        do {
            objectListing = this.amazonS3.listObjects(listObjectsRequest);
            objectSummaries.addAll(objectListing.getObjectSummaries());
            listObjectsRequest.setMarker(objectListing.getNextMarker());
        } while (objectListing.isTruncated());
        return objectSummaries.toArray(new S3ObjectSummary[objectSummaries.size()]);
    }

    private String resolveBucket(String bucket) {
        if (this.resourceIdResolver != null) {
            return this.resourceIdResolver.resolveToPhysicalResourceId(bucket);
        }
        return bucket;
    }

    public String[] listNames(String path) throws IOException {
        ObjectListing objectListing;
        String[] bucketPrefix = path.split("/");
        Assert.state((bucketPrefix.length > 0 && bucketPrefix[0].length() >= 3 ? 1 : 0) != 0, (String)"S3 bucket name must be at least 3 characters long.");
        String bucket = this.resolveBucket(bucketPrefix[0]);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucket);
        if (bucketPrefix.length > 1) {
            listObjectsRequest.setPrefix(bucketPrefix[1]);
        }
        ArrayList<String> names = new ArrayList<String>();
        do {
            objectListing = this.amazonS3.listObjects(listObjectsRequest);
            for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
                names.add(objectSummary.getKey());
            }
            listObjectsRequest.setMarker(objectListing.getNextMarker());
        } while (objectListing.isTruncated());
        return names.toArray(new String[names.size()]);
    }

    public boolean remove(String path) throws IOException {
        String[] bucketKey = this.splitPathToBucketAndKey(path);
        this.amazonS3.deleteObject(bucketKey[0], bucketKey[1]);
        return true;
    }

    public void rename(String pathFrom, String pathTo) throws IOException {
        String[] bucketKeyFrom = this.splitPathToBucketAndKey(pathFrom);
        String[] bucketKeyTo = this.splitPathToBucketAndKey(pathTo);
        CopyObjectRequest copyRequest = new CopyObjectRequest(bucketKeyFrom[0], bucketKeyFrom[1], bucketKeyTo[0], bucketKeyTo[1]);
        this.amazonS3.copyObject(copyRequest);
        this.amazonS3.deleteObject(bucketKeyFrom[0], bucketKeyFrom[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(String source, OutputStream outputStream) throws IOException {
        String[] bucketKey = this.splitPathToBucketAndKey(source);
        S3Object s3Object = this.amazonS3.getObject(bucketKey[0], bucketKey[1]);
        try (S3ObjectInputStream objectContent = s3Object.getObjectContent();){
            StreamUtils.copy((InputStream)objectContent, (OutputStream)outputStream);
        }
    }

    public void write(InputStream inputStream, String destination) throws IOException {
        Assert.notNull((Object)inputStream, (String)"'inputStream' must not be null.");
        String[] bucketKey = this.splitPathToBucketAndKey(destination);
        this.amazonS3.putObject(bucketKey[0], bucketKey[1], inputStream, new ObjectMetadata());
    }

    public void append(InputStream inputStream, String destination) throws IOException {
        throw new UnsupportedOperationException("The 'append' operation isn't supported by the Amazon S3 protocol.");
    }

    public boolean mkdir(String directory) throws IOException {
        this.amazonS3.createBucket(directory);
        return true;
    }

    public boolean rmdir(String directory) throws IOException {
        this.amazonS3.deleteBucket(this.resolveBucket(directory));
        return true;
    }

    public boolean exists(String path) throws IOException {
        String[] bucketKey = this.splitPathToBucketAndKey(path);
        try {
            this.amazonS3.getObjectMetadata(bucketKey[0], bucketKey[1]);
        }
        catch (AmazonS3Exception e) {
            if (404 == e.getStatusCode()) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public InputStream readRaw(String source) throws IOException {
        String[] bucketKey = this.splitPathToBucketAndKey(source);
        S3Object s3Object = this.amazonS3.getObject(bucketKey[0], bucketKey[1]);
        return s3Object.getObjectContent();
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public boolean finalizeRaw() throws IOException {
        return true;
    }

    public Object getClientInstance() {
        return this.amazonS3;
    }

    private String[] splitPathToBucketAndKey(String path) {
        Assert.hasText((String)path, (String)"'path' must not be empty String.");
        String[] bucketKey = path.split("/");
        Assert.state((bucketKey.length == 2 ? 1 : 0) != 0, (String)"'path' must in pattern [BUCKET/KEY].");
        Assert.state((bucketKey[0].length() >= 3 ? 1 : 0) != 0, (String)"S3 bucket name must be at least 3 characters long.");
        bucketKey[0] = this.resolveBucket(bucketKey[0]);
        return bucketKey;
    }
}

