/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.inbound;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.IOException;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.support.S3Session;
import org.springframework.integration.aws.support.S3SessionFactory;
import org.springframework.integration.aws.support.filters.S3PersistentAcceptOnceFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;

public class S3InboundFileSynchronizer
extends AbstractInboundFileSynchronizer<S3ObjectSummary> {
    public S3InboundFileSynchronizer() {
        this(new S3SessionFactory());
    }

    public S3InboundFileSynchronizer(AmazonS3 amazonS3) {
        this(new S3SessionFactory(amazonS3));
    }

    public S3InboundFileSynchronizer(SessionFactory<S3ObjectSummary> sessionFactory) {
        super(sessionFactory);
        this.doSetRemoteDirectoryExpression((Expression)new LiteralExpression(null));
        this.doSetFilter((FileListFilter)new S3PersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "s3MessageSource"));
    }

    protected boolean isFile(S3ObjectSummary file) {
        return true;
    }

    protected String getFilename(S3ObjectSummary file) {
        return file != null ? file.getKey() : null;
    }

    protected long getModified(S3ObjectSummary file) {
        return file.getLastModified().getTime();
    }

    protected boolean copyFileToLocalDirectory(String remoteDirectoryPath, S3ObjectSummary remoteFile, File localDirectory, Session<S3ObjectSummary> session) throws IOException {
        return super.copyFileToLocalDirectory(((S3Session)session).normalizeBucketName(remoteDirectoryPath), (Object)remoteFile, localDirectory, session);
    }
}

